/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.rpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.oc2.common.bus.device.rpc.RPCItemStackTagFilter;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RPCItemStackTagFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ArrayList<RPCItemStackTagFilter> FILTERS = new ArrayList();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(RPCItemStackTagFilters::handleAddReloadListenerEvent);
    }

    @Nullable
    public static CompoundNBT getFilteredTag(ItemStack stack, CompoundNBT tag) {
        CompoundNBT result = new CompoundNBT();
        for (RPCItemStackTagFilter filter : FILTERS) {
            CompoundNBT filtered = filter.apply(stack, tag);
            if (filtered == null) continue;
            result.func_197643_a(filtered);
        }
        return result;
    }

    private static void handleAddReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)ReloadListener.INSTANCE);
    }

    private static final class ReloadListener
    extends JsonReloadListener {
        private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "item_tag_filters");
        }

        protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager resourceManager, IProfiler profiler) {
            FILTERS.clear();
            objects.forEach((location, element) -> {
                try {
                    RPCItemStackTagFilter filter = (RPCItemStackTagFilter)GSON.fromJson(element, RPCItemStackTagFilter.class);
                    if (filter != null) {
                        FILTERS.add(filter);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed loading item tag filter [{}].", location, (Object)e);
                }
            });
        }
    }
}

