/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.bus.device.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.ItemDevice;
import li.cil.oc2.api.bus.device.provider.BlockDeviceProvider;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.bus.device.provider.ItemDeviceProvider;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.bus.device.provider.Providers;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.bus.device.util.ItemDeviceInfo;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;

public final class Devices {
    public static BlockDeviceQuery makeQuery(TileEntity tileEntity, @Nullable Direction side) {
        World world = Objects.requireNonNull(tileEntity.func_145831_w());
        BlockPos pos = tileEntity.func_174877_v();
        return new BlockQuery(world, pos, side);
    }

    public static BlockDeviceQuery makeQuery(World world, BlockPos pos, @Nullable Direction side) {
        return new BlockQuery(world, pos, side);
    }

    public static ItemDeviceQuery makeQuery(ItemStack stack) {
        return new ItemQuery(stack);
    }

    public static ItemDeviceQuery makeQuery(TileEntity tileEntity, ItemStack stack) {
        return new ItemQuery(tileEntity, stack);
    }

    public static ItemDeviceQuery makeQuery(Entity entity, ItemStack stack) {
        return new ItemQuery(entity, stack);
    }

    public static List<LazyOptional<BlockDeviceInfo>> getDevices(BlockDeviceQuery query) {
        IForgeRegistry<BlockDeviceProvider> registry = Providers.BLOCK_DEVICE_PROVIDER_REGISTRY.get();
        ArrayList<LazyOptional<BlockDeviceInfo>> devices = new ArrayList<LazyOptional<BlockDeviceInfo>>();
        for (BlockDeviceProvider provider : registry.getValues()) {
            LazyOptional<Device> device = provider.getDevice(query);
            if (!device.isPresent()) continue;
            LazyOptional info = device.lazyMap(d -> new BlockDeviceInfo(provider, (Device)d));
            device.addListener(unused -> info.invalidate());
            devices.add((LazyOptional<BlockDeviceInfo>)info);
        }
        return devices;
    }

    public static List<ItemDeviceInfo> getDevices(ItemDeviceQuery query) {
        IForgeRegistry<ItemDeviceProvider> registry = Providers.ITEM_DEVICE_PROVIDER_REGISTRY.get();
        ArrayList<ItemDeviceInfo> devices = new ArrayList<ItemDeviceInfo>();
        for (ItemDeviceProvider provider : registry.getValues()) {
            Optional<ItemDevice> device = provider.getDevice(query);
            device.ifPresent(d -> devices.add(new ItemDeviceInfo(provider, (ItemDevice)d, provider.getEnergyConsumption(query))));
        }
        return devices;
    }

    public static Collection<DeviceType> getDeviceTypes(ItemDeviceQuery query) {
        IForgeRegistry<ItemDeviceProvider> registry = Providers.ITEM_DEVICE_PROVIDER_REGISTRY.get();
        HashSet<DeviceType> deviceTypes = new HashSet<DeviceType>();
        for (ItemDeviceProvider provider : registry.getValues()) {
            Optional<DeviceType> device = provider.getDeviceType(query);
            device.ifPresent(deviceTypes::add);
        }
        return deviceTypes;
    }

    public static int getEnergyConsumption(ItemDeviceQuery query) {
        IForgeRegistry<ItemDeviceProvider> registry = Providers.ITEM_DEVICE_PROVIDER_REGISTRY.get();
        long accumulator = 0L;
        for (ItemDeviceProvider provider : registry.getValues()) {
            accumulator += (long)Math.max(0, provider.getEnergyConsumption(query));
        }
        if (accumulator > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)accumulator;
    }

    private static final class ItemQuery
    implements ItemDeviceQuery {
        @Nullable
        private final TileEntity tileEntity;
        @Nullable
        private final Entity entity;
        private final ItemStack stack;

        public ItemQuery(ItemStack stack) {
            this.tileEntity = null;
            this.entity = null;
            this.stack = stack;
        }

        public ItemQuery(TileEntity tileEntity, ItemStack stack) {
            this.tileEntity = tileEntity;
            this.entity = null;
            this.stack = stack;
        }

        public ItemQuery(Entity entity, ItemStack stack) {
            this.tileEntity = null;
            this.entity = entity;
            this.stack = stack;
        }

        @Override
        public Optional<TileEntity> getContainerTileEntity() {
            return Optional.ofNullable(this.tileEntity);
        }

        @Override
        public Optional<Entity> getContainerEntity() {
            return Optional.ofNullable(this.entity);
        }

        @Override
        public ItemStack getItemStack() {
            return this.stack;
        }
    }

    private static class BlockQuery
    implements BlockDeviceQuery {
        private final World world;
        private final BlockPos pos;
        @Nullable
        private final Direction side;

        public BlockQuery(World world, BlockPos pos, @Nullable Direction side) {
            this.world = world;
            this.pos = pos;
            this.side = side;
        }

        @Override
        public World getLevel() {
            return this.world;
        }

        @Override
        public BlockPos getQueryPosition() {
            return this.pos;
        }

        @Override
        @Nullable
        public Direction getQuerySide() {
            return this.side;
        }
    }
}

