/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import java.nio.ByteBuffer;
import li.cil.oc2.common.block.Blocks;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.ComputerPowerMessage;
import li.cil.oc2.common.network.message.ComputerTerminalInputMessage;
import li.cil.oc2.common.network.message.OpenComputerInventoryMessage;
import li.cil.oc2.common.network.message.OpenComputerTerminalMessage;
import li.cil.oc2.common.tileentity.ComputerTileEntity;
import li.cil.oc2.common.vm.Terminal;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class AbstractComputerContainer
extends AbstractMachineTerminalContainer {
    private final ComputerTileEntity computer;

    protected AbstractComputerContainer(ContainerType<?> type, int id, PlayerEntity player, ComputerTileEntity computer, IIntArray energyInfo) {
        super(type, id, energyInfo);
        this.computer = computer;
        this.computer.addTerminalUser(player);
    }

    @Override
    public void switchToInventory() {
        Network.INSTANCE.sendToServer((Object)new OpenComputerInventoryMessage(this.computer));
    }

    @Override
    public void switchToTerminal() {
        Network.INSTANCE.sendToServer((Object)new OpenComputerTerminalMessage(this.computer));
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.computer.getVirtualMachine();
    }

    @Override
    public void sendPowerStateToServer(boolean value) {
        Network.INSTANCE.sendToServer((Object)new ComputerPowerMessage(this.computer, value));
    }

    @Override
    public Terminal getTerminal() {
        return this.computer.getTerminal();
    }

    @Override
    public void sendTerminalInputToServer(ByteBuffer input) {
        Network.INSTANCE.sendToServer((Object)new ComputerTerminalInputMessage(this.computer, input));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return !this.computer.func_145837_r() && AbstractComputerContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.computer.func_145831_w(), (BlockPos)this.computer.func_174877_v()), (PlayerEntity)player, (Block)((Block)Blocks.COMPUTER.get()));
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.computer.removeTerminalUser(player);
    }

    protected static IIntArray createEnergyInfo(final IEnergyStorage energy, final CommonDeviceBusController busController) {
        return new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return energy.getEnergyStored();
                    }
                    case 1: {
                        return energy.getMaxEnergyStored();
                    }
                    case 2: {
                        return busController.getEnergyConsumption();
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
            }

            public int func_221478_a() {
                return 3;
            }
        };
    }
}

