/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import java.nio.ByteBuffer;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractMachineTerminalContainer;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.entity.RobotEntity;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.OpenRobotInventoryMessage;
import li.cil.oc2.common.network.message.OpenRobotTerminalMessage;
import li.cil.oc2.common.network.message.RobotPowerMessage;
import li.cil.oc2.common.network.message.RobotTerminalInputMessage;
import li.cil.oc2.common.vm.Terminal;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.IIntArray;

public abstract class AbstractRobotContainer
extends AbstractMachineTerminalContainer {
    private final RobotEntity robot;

    public AbstractRobotContainer(ContainerType<?> type, int id, RobotEntity robot, IIntArray energyInfo) {
        super(type, id, energyInfo);
        this.robot = robot;
    }

    @Override
    public void switchToInventory() {
        Network.INSTANCE.sendToServer((Object)new OpenRobotInventoryMessage(this.robot));
    }

    @Override
    public void switchToTerminal() {
        Network.INSTANCE.sendToServer((Object)new OpenRobotTerminalMessage(this.robot));
    }

    public RobotEntity getRobot() {
        return this.robot;
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.robot.getVirtualMachine();
    }

    @Override
    public void sendPowerStateToServer(boolean value) {
        Network.INSTANCE.sendToServer((Object)new RobotPowerMessage(this.robot, value));
    }

    @Override
    public Terminal getTerminal() {
        return this.robot.getTerminal();
    }

    @Override
    public void sendTerminalInputToServer(ByteBuffer input) {
        Network.INSTANCE.sendToServer((Object)new RobotTerminalInputMessage(this.robot, input));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return this.robot.func_70089_S() && this.robot.func_233562_a_((Entity)player, 8.0);
    }

    protected static IIntArray createEnergyInfo(final FixedEnergyStorage energy, final CommonDeviceBusController busController) {
        return new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return energy.getEnergyStored();
                    }
                    case 1: {
                        return energy.getMaxEnergyStored();
                    }
                    case 2: {
                        return busController.getEnergyConsumption();
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
            }

            public int func_221478_a() {
                return 3;
            }
        };
    }
}

