/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractComputerContainer;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.container.TypedSlotItemHandler;
import li.cil.oc2.common.tileentity.ComputerTileEntity;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public final class ComputerInventoryContainer
extends AbstractComputerContainer {
    public static void createServer(final ComputerTileEntity computer, final IEnergyStorage energy, final CommonDeviceBusController busController, ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(computer.func_195044_w().func_177230_c().func_149739_a());
            }

            public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                return new ComputerInventoryContainer(id, computer, player, AbstractComputerContainer.createEnergyInfo(energy, busController));
            }
        }, (BlockPos)computer.func_174877_v());
    }

    public static ComputerInventoryContainer createClient(int id, PlayerInventory playerInventory, PacketBuffer data) {
        BlockPos pos = data.func_179259_c();
        TileEntity tileEntity = playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        if (!(tileEntity instanceof ComputerTileEntity)) {
            throw new IllegalArgumentException();
        }
        return new ComputerInventoryContainer(id, (ComputerTileEntity)tileEntity, playerInventory.field_70458_d, ComputerInventoryContainer.createEnergyInfo());
    }

    private ComputerInventoryContainer(int id, ComputerTileEntity computer, PlayerEntity player, IIntArray energyInfo) {
        super((ContainerType)Containers.COMPUTER.get(), id, player, computer, energyInfo);
        VMItemStackHandlers handlers = computer.getItemStackHandlers();
        handlers.getItemHandler(DeviceTypes.FLASH_MEMORY).ifPresent(itemHandler -> {
            if (itemHandler.getSlots() > 0) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.FLASH_MEMORY, 0, 64, 78));
            }
        });
        handlers.getItemHandler(DeviceTypes.MEMORY).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.MEMORY, slot, 64 + slot * 18, 24));
            }
        });
        handlers.getItemHandler(DeviceTypes.HARD_DRIVE).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.HARD_DRIVE, slot, 100 + slot % 2 * 18, 60 + slot / 2 * 18));
            }
        });
        handlers.getItemHandler(DeviceTypes.CARD).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.CARD, slot, 38, 24 + slot * 18));
            }
        });
        this.createPlayerInventoryAndHotbarSlots(player.field_71071_by, 8, 115);
    }
}

