/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import java.util.function.Function;
import javax.annotation.Nonnull;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.bus.ItemHandlerDeviceBusElement;
import li.cil.oc2.common.container.FixedSizeItemStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;

public class DeviceItemStackHandler
extends FixedSizeItemStackHandler {
    private final ItemHandlerDeviceBusElement busElement;

    public DeviceItemStackHandler(int size, Function<ItemStack, ItemDeviceQuery> queryFactory) {
        this((NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a), queryFactory);
    }

    public DeviceItemStackHandler(NonNullList<ItemStack> stacks, Function<ItemStack, ItemDeviceQuery> queryFactory) {
        super(stacks);
        this.busElement = new ItemHandlerDeviceBusElement(this.getSlots(), queryFactory);
    }

    public ItemHandlerDeviceBusElement getBusElement() {
        return this.busElement;
    }

    public void exportDeviceDataToItemStacks() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.busElement.exportDeviceDataToItemStack(slot, this.getStackInSlot(slot));
        }
    }

    public final CompoundNBT serializeNBT() {
        throw new UnsupportedOperationException("Use saveItems and saveDevices instead.");
    }

    @Override
    public final void deserializeNBT(CompoundNBT tag) {
        throw new UnsupportedOperationException("Use loadItems and loadDevices instead.");
    }

    public CompoundNBT saveItems() {
        return super.serializeNBT();
    }

    public CompoundNBT saveDevices() {
        return this.busElement.save();
    }

    public void loadItems(CompoundNBT tag) {
        super.deserializeNBT(tag);
    }

    public void loadDevices(CompoundNBT tag) {
        this.busElement.load(tag);
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.busElement.updateDevices(slot, this.getStackInSlot(slot));
        }
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack stack = super.getStackInSlot(slot);
        this.busElement.exportDeviceDataToItemStack(slot, stack);
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!simulate && amount > 0) {
            this.busElement.exportDeviceDataToItemStack(slot, super.getStackInSlot(slot));
        }
        return super.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.busElement.updateDevices(slot, this.getStackInSlot(slot));
    }
}

