/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.container;

import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.container.AbstractRobotContainer;
import li.cil.oc2.common.container.Containers;
import li.cil.oc2.common.container.TypedSlotItemHandler;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.entity.RobotEntity;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public final class RobotInventoryContainer
extends AbstractRobotContainer {
    public static void createServer(final RobotEntity robot, final FixedEnergyStorage energy, final CommonDeviceBusController busController, ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return robot.func_200200_C_();
            }

            public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                return new RobotInventoryContainer(id, robot, player, AbstractRobotContainer.createEnergyInfo(energy, busController));
            }
        }, b -> b.func_150787_b(robot.func_145782_y()));
    }

    public static RobotInventoryContainer createClient(int id, PlayerInventory inventory, PacketBuffer data) {
        int entityId = data.func_150792_a();
        Entity entity = inventory.field_70458_d.field_70170_p.func_73045_a(entityId);
        if (!(entity instanceof RobotEntity)) {
            throw new IllegalArgumentException();
        }
        return new RobotInventoryContainer(id, (RobotEntity)entity, inventory.field_70458_d, RobotInventoryContainer.createEnergyInfo());
    }

    private RobotInventoryContainer(int id, RobotEntity robot, PlayerEntity player, IIntArray energyInfo) {
        super((ContainerType)Containers.ROBOT.get(), id, robot, energyInfo);
        VMItemStackHandlers handlers = robot.getItemStackHandlers();
        handlers.getItemHandler(DeviceTypes.FLASH_MEMORY).ifPresent(itemHandler -> {
            if (itemHandler.getSlots() > 0) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.FLASH_MEMORY, 0, 34, 78));
            }
        });
        handlers.getItemHandler(DeviceTypes.MEMORY).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.MEMORY, slot, 34 + slot * 18, 24));
            }
        });
        handlers.getItemHandler(DeviceTypes.HARD_DRIVE).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.HARD_DRIVE, slot, 70 + slot % 2 * 18, 60 + slot / 2 * 18));
            }
        });
        handlers.getItemHandler(DeviceTypes.ROBOT_MODULE).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                this.func_75146_a((Slot)new TypedSlotItemHandler((IItemHandler)itemHandler, DeviceTypes.ROBOT_MODULE, slot, 8, 24 + slot * 18));
            }
        });
        ItemStackHandler inventory = robot.getInventory();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            int x = 116 + slot % 3 * 18;
            int y = 24 + slot / 3 * 18;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, slot, x, y));
        }
        this.createPlayerInventoryAndHotbarSlots(player.field_71071_by, 8, 115);
    }
}

