/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.ObjectDevice;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.capabilities.Robot;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.bus.AbstractDeviceBusElement;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.DeviceItemStackHandler;
import li.cil.oc2.common.container.FixedSizeItemStackHandler;
import li.cil.oc2.common.container.RobotInventoryContainer;
import li.cil.oc2.common.container.RobotTerminalContainer;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.MovementDirection;
import li.cil.oc2.common.entity.robot.RobotActionResult;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.entity.robot.RobotMovementAction;
import li.cil.oc2.common.entity.robot.RobotRotationAction;
import li.cil.oc2.common.entity.robot.RotationDirection;
import li.cil.oc2.common.integration.Wrenches;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.RobotBootErrorMessage;
import li.cil.oc2.common.network.message.RobotBusStateMessage;
import li.cil.oc2.common.network.message.RobotInitializationRequestMessage;
import li.cil.oc2.common.network.message.RobotRunStateMessage;
import li.cil.oc2.common.network.message.RobotTerminalOutputMessage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TerminalUtils;
import li.cil.oc2.common.util.WorldUtils;
import li.cil.oc2.common.vm.AbstractTerminalVMRunner;
import li.cil.oc2.common.vm.AbstractVMItemStackHandlers;
import li.cil.oc2.common.vm.AbstractVirtualMachine;
import li.cil.oc2.common.vm.Terminal;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import li.cil.oc2.common.vm.VMRunState;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public final class RobotEntity
extends Entity
implements Robot {
    public static final DataParameter<BlockPos> TARGET_POSITION = EntityDataManager.func_187226_a(RobotEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<Direction> TARGET_DIRECTION = EntityDataManager.func_187226_a(RobotEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    public static final DataParameter<Byte> SELECTED_SLOT = EntityDataManager.func_187226_a(RobotEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final String TERMINAL_TAG_NAME = "terminal";
    private static final String STATE_TAG_NAME = "state";
    private static final String BUS_ELEMENT_TAG_NAME = "bus_element";
    private static final String DEVICES_TAG_NAME = "devices";
    private static final String COMMAND_PROCESSOR_TAG_NAME = "commands";
    private static final String INVENTORY_TAG_NAME = "inventory";
    private static final String SELECTED_SLOT_TAG_NAME = "selected_slot";
    private static final int MAX_QUEUED_ACTIONS = 16;
    private static final int MAX_QUEUED_RESULTS = 16;
    private static final int MEMORY_SLOTS = 4;
    private static final int HARD_DRIVE_SLOTS = 2;
    private static final int FLASH_MEMORY_SLOTS = 1;
    private static final int MODULE_SLOTS = 4;
    private static final int INVENTORY_SIZE = 12;
    private final Consumer<ChunkEvent.Unload> chunkUnloadListener = this::handleChunkUnload;
    private final Consumer<WorldEvent.Unload> worldUnloadListener = this::handleWorldUnload;
    private final BlockPos.Mutable mutablePosition = new BlockPos.Mutable();
    private final AnimationState animationState = new AnimationState();
    private final RobotActionProcessor actionProcessor = new RobotActionProcessor();
    private final Terminal terminal = new Terminal();
    private final RobotVirtualMachine virtualMachine;
    private final RobotBusElement busElement = new RobotBusElement();
    private final RobotItemStackHandlers deviceItems = new RobotItemStackHandlers();
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.robotEnergyStorage);
    private final ItemStackHandler inventory = new FixedSizeItemStackHandler(12);
    private long lastPistonMovement;

    public RobotEntity(EntityType<?> type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.func_189654_d(true);
        CommonDeviceBusController busController = new CommonDeviceBusController(this.busElement, Config.robotEnergyPerTick);
        this.virtualMachine = new RobotVirtualMachine(busController);
        this.virtualMachine.state.builtinDevices.rtcMinecraft.setWorld(world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public VMItemStackHandlers getItemStackHandlers() {
        return this.deviceItems;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public int getSelectedSlot() {
        return ((Byte)this.func_184212_Q().func_187225_a(SELECTED_SLOT)).byteValue();
    }

    @Override
    public void setSelectedSlot(int value) {
        this.func_184212_Q().func_187227_b(SELECTED_SLOT, (Object)((byte)MathHelper.func_76125_a((int)value, (int)0, (int)11)));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (capability == Capabilities.ENERGY_STORAGE && Config.robotsUseEnergy()) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        if (capability == Capabilities.ROBOT) {
            return LazyOptional.of(() -> this).cast();
        }
        LazyOptional optional = super.getCapability(capability, side);
        if (optional.isPresent()) {
            return optional;
        }
        for (Device device : this.virtualMachine.busController.getDevices()) {
            LazyOptional value;
            if (!(device instanceof ICapabilityProvider) || !(value = ((ICapabilityProvider)device).getCapability(capability, side)).isPresent()) continue;
            return value;
        }
        return LazyOptional.empty();
    }

    public long getLastPistonMovement() {
        return this.lastPistonMovement;
    }

    public void start() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        this.virtualMachine.start();
    }

    public void stop() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        this.virtualMachine.stop();
    }

    public void openTerminalScreen(ServerPlayerEntity player) {
        RobotTerminalContainer.createServer(this, this.energy, this.virtualMachine.busController, player);
    }

    public void openInventoryScreen(ServerPlayerEntity player) {
        RobotInventoryContainer.createServer(this, this.energy, this.virtualMachine.busController, player);
    }

    public void dropSelf() {
        if (!this.func_70089_S()) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)Items.ROBOT.get());
        this.exportToItemStack(stack);
        this.func_199701_a_(stack);
        this.func_70106_y();
        WorldUtils.playSound((IWorld)this.field_70170_p, this.func_233580_cy_(), SoundType.field_185852_e, SoundType::func_185845_c);
    }

    public void func_70071_h_() {
        boolean isClient = this.field_70170_p.func_201670_d();
        if (this.field_70148_d) {
            if (isClient) {
                this.requestInitialState();
            } else {
                this.registerListeners();
                RobotActions.initializeData(this);
                if (this.actionProcessor.action != null) {
                    this.actionProcessor.action.initialize(this);
                }
            }
        }
        super.func_70071_h_();
        if (!isClient) {
            this.virtualMachine.tick();
        }
        this.actionProcessor.tick();
        if (!isClient && this.field_70170_p instanceof ServerWorld) {
            VoxelShape shape = VoxelShapes.func_197881_a((AxisAlignedBB)this.func_174813_aQ());
            CubeCoordinateIterator iterator = this.getBlockPosIterator();
            while (iterator.func_218301_a()) {
                VoxelShape blockShape;
                int x = iterator.func_218304_b();
                int y = iterator.func_218302_c();
                int z = iterator.func_218303_d();
                this.mutablePosition.func_181079_c(x, y, z);
                BlockState blockState = this.field_70170_p.func_180495_p((BlockPos)this.mutablePosition);
                if (blockState.isAir((IBlockReader)this.field_70170_p, (BlockPos)this.mutablePosition) || blockState.func_203425_a(Blocks.field_196603_bb) || blockState.func_203425_a(Blocks.field_150332_K) || !VoxelShapes.func_197879_c((VoxelShape)shape, (VoxelShape)(blockShape = blockState.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)this.mutablePosition)).func_197751_a((double)x, (double)y, (double)z), (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                TileEntity tileEntity = blockState.hasTileEntity() ? this.field_70170_p.func_175625_s((BlockPos)this.mutablePosition) : null;
                LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216023_a(this.field_70170_p.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216015_a(LootParameters.field_216287_g, (Object)blockState).func_216021_b(LootParameters.field_216288_h, (Object)tileEntity);
                List drops = blockState.func_215693_a(builder);
                this.field_70170_p.func_175656_a((BlockPos)this.mutablePosition, Blocks.field_150350_a.func_176223_P());
                for (ItemStack drop : drops) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.mutablePosition, (ItemStack)drop);
                }
            }
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70170_p.func_201670_d()) {
            if (Wrenches.isWrench(stack)) {
                if (player.func_225608_bj_()) {
                    this.dropSelf();
                } else if (player instanceof ServerPlayerEntity) {
                    this.openInventoryScreen((ServerPlayerEntity)player);
                }
            } else if (player.func_225608_bj_()) {
                this.start();
            } else if (player instanceof ServerPlayerEntity) {
                this.openTerminalScreen((ServerPlayerEntity)player);
            }
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        this.virtualMachine.suspend();
        this.virtualMachine.state.vmAdapter.unmount();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_241849_j(Entity entity) {
        return entity != this;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_230269_aK_() {
        return false;
    }

    public void exportToItemStack(ItemStack stack) {
        CompoundNBT itemsTag = NBTUtils.getOrCreateChildTag(stack.func_196082_o(), "oc2", "items");
        this.deviceItems.saveItems(itemsTag);
        itemsTag.func_218657_a(INVENTORY_TAG_NAME, (INBT)this.inventory.serializeNBT());
        NBTUtils.getOrCreateChildTag(stack.func_196082_o(), "oc2").func_218657_a("energy", (INBT)this.energy.serializeNBT());
    }

    public void importFromItemStack(ItemStack stack) {
        CompoundNBT itemsTag = NBTUtils.getChildTag(stack.func_77978_p(), "oc2", "items");
        this.deviceItems.loadItems(itemsTag);
        this.inventory.deserializeNBT(itemsTag.func_74775_l(INVENTORY_TAG_NAME));
        this.energy.deserializeNBT(NBTUtils.getChildTag(stack.func_77978_p(), "oc2", "energy"));
    }

    protected void func_70088_a() {
        EntityDataManager dataManager = this.func_184212_Q();
        dataManager.func_187214_a(TARGET_POSITION, (Object)BlockPos.field_177992_a);
        dataManager.func_187214_a(TARGET_DIRECTION, (Object)Direction.NORTH);
        dataManager.func_187214_a(SELECTED_SLOT, (Object)0);
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_218657_a(STATE_TAG_NAME, (INBT)this.virtualMachine.serialize());
        tag.func_218657_a(TERMINAL_TAG_NAME, (INBT)NBTSerialization.serialize(this.terminal));
        tag.func_218657_a(COMMAND_PROCESSOR_TAG_NAME, (INBT)this.actionProcessor.serialize());
        tag.func_218657_a(BUS_ELEMENT_TAG_NAME, (INBT)this.busElement.serialize());
        tag.func_218657_a("items", (INBT)this.deviceItems.saveItems());
        tag.func_218657_a(DEVICES_TAG_NAME, (INBT)this.deviceItems.saveDevices());
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a(INVENTORY_TAG_NAME, (INBT)this.inventory.serializeNBT());
        tag.func_74774_a(SELECTED_SLOT_TAG_NAME, ((Byte)this.func_184212_Q().func_187225_a(SELECTED_SLOT)).byteValue());
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.virtualMachine.deserialize(tag.func_74775_l(STATE_TAG_NAME));
        NBTSerialization.deserialize(tag.func_74775_l(TERMINAL_TAG_NAME), this.terminal);
        this.actionProcessor.deserialize(tag.func_74775_l(COMMAND_PROCESSOR_TAG_NAME));
        this.busElement.deserialize(tag.func_74775_l(BUS_ELEMENT_TAG_NAME));
        this.deviceItems.loadItems(tag.func_74775_l("items"));
        this.deviceItems.loadDevices(tag.func_74775_l(DEVICES_TAG_NAME));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l(INVENTORY_TAG_NAME));
        this.setSelectedSlot(tag.func_74771_c(SELECTED_SLOT_TAG_NAME));
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_145775_I() {
    }

    protected Vector3d func_213308_a(Vector3d pos) {
        this.lastPistonMovement = this.field_70170_p.func_82737_E();
        return super.func_213308_a(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void requestInitialState() {
        Network.INSTANCE.sendToServer((Object)new RobotInitializationRequestMessage(this));
    }

    private void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(this.chunkUnloadListener);
        MinecraftForge.EVENT_BUS.addListener(this.worldUnloadListener);
    }

    private void unregisterListeners() {
        MinecraftForge.EVENT_BUS.unregister(this.chunkUnloadListener);
        MinecraftForge.EVENT_BUS.unregister(this.worldUnloadListener);
    }

    private void handleChunkUnload(ChunkEvent.Unload event) {
        if (event.getWorld() != this.field_70170_p) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(this.func_233580_cy_());
        if (!Objects.equals(chunkPos, event.getChunk().func_76632_l())) {
            return;
        }
        this.unregisterListeners();
        this.virtualMachine.suspend();
    }

    private void handleWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() != this.field_70170_p) {
            return;
        }
        this.unregisterListeners();
        this.virtualMachine.suspend();
    }

    private CubeCoordinateIterator getBlockPosIterator() {
        AxisAlignedBB bounds = this.func_174813_aQ();
        return new CubeCoordinateIterator(MathHelper.func_76128_c((double)bounds.field_72340_a), MathHelper.func_76128_c((double)bounds.field_72338_b), MathHelper.func_76128_c((double)bounds.field_72339_c), MathHelper.func_76128_c((double)bounds.field_72336_d), MathHelper.func_76128_c((double)bounds.field_72337_e), MathHelper.func_76128_c((double)bounds.field_72334_f));
    }

    private static float lerpClamped(float from, float to, float delta) {
        if (from < to) {
            return Math.min(from + delta, to);
        }
        if (from > to) {
            return Math.max(from - delta, to);
        }
        return from;
    }

    private static float remapFrom01To(float x, float a1, float b1) {
        if (a1 == b1) {
            return a1;
        }
        return x * (b1 - a1) + a1;
    }

    public final class RobotDevice {
        @Callback(synchronize=false)
        public int getEnergyStored() {
            return RobotEntity.this.energy.getEnergyStored();
        }

        @Callback(synchronize=false)
        public int getEnergyCapacity() {
            return RobotEntity.this.energy.getMaxEnergyStored();
        }

        @Callback(synchronize=false)
        public int getSelectedSlot() {
            return RobotEntity.this.getSelectedSlot();
        }

        @Callback(synchronize=false)
        public void setSelectedSlot(@Parameter(value="slot") int slot) {
            RobotEntity.this.setSelectedSlot(slot);
        }

        @Callback
        public ItemStack getStackInSlot(@Parameter(value="slot") int slot) {
            return RobotEntity.this.inventory.getStackInSlot(slot);
        }

        @Callback(synchronize=false)
        public boolean move(@Parameter(value="direction") @Nullable MovementDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException();
            }
            return RobotEntity.this.actionProcessor.move(direction);
        }

        @Callback(synchronize=false)
        public boolean turn(@Parameter(value="direction") @Nullable RotationDirection direction) {
            if (direction == null) {
                throw new IllegalArgumentException();
            }
            return RobotEntity.this.actionProcessor.rotate(direction);
        }

        @Callback(synchronize=false)
        public int getLastActionId() {
            return RobotEntity.this.actionProcessor.lastActionId;
        }

        @Callback(synchronize=false)
        public int getQueuedActionCount() {
            return RobotEntity.this.actionProcessor.getQueuedActionCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @Callback(synchronize=false)
        public RobotActionResult getActionResult(@Parameter(value="actionId") int actionId) {
            AbstractRobotAction currentAction = RobotEntity.this.actionProcessor.action;
            if (currentAction != null && currentAction.getId() == actionId) {
                return RobotActionResult.INCOMPLETE;
            }
            Queue queue = RobotEntity.this.actionProcessor.queue;
            synchronized (queue) {
                for (AbstractRobotAction action : RobotEntity.this.actionProcessor.queue) {
                    if (action.getId() != actionId) continue;
                    return RobotActionResult.INCOMPLETE;
                }
            }
            queue = RobotEntity.this.actionProcessor.results;
            synchronized (queue) {
                for (RobotActionProcessorResult result : RobotEntity.this.actionProcessor.results) {
                    if (result.actionId != actionId) continue;
                    return result.result;
                }
            }
            return null;
        }

        private RobotDevice() {
        }
    }

    private final class RobotVirtualMachine
    extends AbstractVirtualMachine {
        private RobotVirtualMachine(CommonDeviceBusController busController) {
            super(busController);
            this.state.vmAdapter.setBaseAddressProvider(RobotEntity.this.deviceItems::getDeviceAddressBase);
        }

        @Override
        protected boolean consumeEnergy(int amount, boolean simulate) {
            if (!Config.robotsUseEnergy()) {
                return true;
            }
            if (amount > RobotEntity.this.energy.getEnergyStored()) {
                return false;
            }
            RobotEntity.this.energy.extractEnergy(amount, simulate);
            return true;
        }

        @Override
        protected void stopRunnerAndReset() {
            super.stopRunnerAndReset();
            TerminalUtils.resetTerminal(RobotEntity.this.terminal, output -> Network.sendToClientsTrackingEntity(new RobotTerminalOutputMessage(RobotEntity.this, (ByteBuffer)output), RobotEntity.this));
            RobotEntity.this.actionProcessor.clear();
        }

        @Override
        protected AbstractTerminalVMRunner createRunner() {
            return new RobotVMRunner(this, RobotEntity.this.terminal);
        }

        @Override
        protected void handleBusStateChanged(CommonDeviceBusController.BusState value) {
            Network.sendToClientsTrackingEntity(new RobotBusStateMessage(RobotEntity.this), RobotEntity.this);
        }

        @Override
        protected void handleRunStateChanged(VMRunState value) {
            Network.sendToClientsTrackingEntity(new RobotRunStateMessage(RobotEntity.this), RobotEntity.this);
        }

        @Override
        protected void handleBootErrorChanged(@Nullable ITextComponent value) {
            Network.sendToClientsTrackingEntity(new RobotBootErrorMessage(RobotEntity.this), RobotEntity.this);
        }
    }

    private final class RobotVMRunner
    extends AbstractTerminalVMRunner {
        public RobotVMRunner(AbstractVirtualMachine virtualMachine, Terminal terminal) {
            super(virtualMachine, terminal);
        }

        @Override
        protected void sendTerminalUpdateToClient(ByteBuffer output) {
            Network.sendToClientsTrackingEntity(new RobotTerminalOutputMessage(RobotEntity.this, output), RobotEntity.this);
        }
    }

    private final class RobotBusElement
    extends AbstractDeviceBusElement {
        private static final String DEVICE_ID_TAG_NAME = "device_id";
        private final Device device;
        private UUID deviceId;

        private RobotBusElement() {
            this.device = new ObjectDevice((Object)new RobotDevice(), "robot");
            this.deviceId = UUID.randomUUID();
        }

        @Override
        public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
            return Optional.of(Collections.singleton(LazyOptional.of(() -> ((RobotEntity)RobotEntity.this).deviceItems.busElement)));
        }

        @Override
        public Collection<Device> getLocalDevices() {
            return Collections.singleton(this.device);
        }

        @Override
        public Optional<UUID> getDeviceIdentifier(Device device) {
            if (device == this.device) {
                return Optional.of(this.deviceId);
            }
            return super.getDeviceIdentifier(device);
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a(DEVICE_ID_TAG_NAME, this.deviceId);
            return tag;
        }

        public void deserialize(CompoundNBT tag) {
            if (tag.func_186855_b(DEVICE_ID_TAG_NAME)) {
                this.deviceId = tag.func_186857_a(DEVICE_ID_TAG_NAME);
            }
        }
    }

    private final class RobotItemStackHandlers
    extends AbstractVMItemStackHandlers {
        public RobotItemStackHandlers() {
            super(AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.MEMORY, 4), AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.HARD_DRIVE, 2), AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.FLASH_MEMORY, 1), AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.ROBOT_MODULE, 4));
        }

        @Override
        protected ItemDeviceQuery getDeviceQuery(ItemStack stack) {
            return Devices.makeQuery(RobotEntity.this, stack);
        }

        @Override
        protected void onContentsChanged(DeviceItemStackHandler itemHandler, int slot) {
            ((RobotEntity)RobotEntity.this).virtualMachine.busController.scheduleBusScan();
        }
    }

    private final class RobotActionProcessor {
        private static final String QUEUE_TAG_NAME = "queue";
        private static final String ACTION_TAG_NAME = "action";
        private static final String RESULTS_TAG_NAME = "results";
        private static final String LAST_ACTION_ID_TAG_NAME = "last_action_id";
        private final Queue<AbstractRobotAction> queue = new ArrayDeque<AbstractRobotAction>(15);
        @Nullable
        private AbstractRobotAction action;
        private final Queue<RobotActionProcessorResult> results = new ArrayDeque<RobotActionProcessorResult>(16);
        private int lastActionId;

        private RobotActionProcessor() {
        }

        public boolean hasQueuedActions() {
            return this.action != null || !this.queue.isEmpty();
        }

        public int getQueuedActionCount() {
            return (this.action != null ? 1 : 0) + this.queue.size();
        }

        public boolean move(MovementDirection direction) {
            return this.addAction(new RobotMovementAction(direction));
        }

        public boolean rotate(RotationDirection direction) {
            return this.addAction(new RobotRotationAction(direction));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick() {
            if (RobotEntity.this.field_70170_p.func_201670_d()) {
                RobotActions.performClient(RobotEntity.this);
            } else {
                RobotActionResult result;
                if (this.action != null && (result = this.action.perform(RobotEntity.this)) != RobotActionResult.INCOMPLETE) {
                    Queue<RobotActionProcessorResult> queue = this.results;
                    synchronized (queue) {
                        if (this.results.size() == 16) {
                            this.results.remove();
                        }
                        this.results.add(new RobotActionProcessorResult(this.action.getId(), result));
                    }
                    this.action = null;
                }
                if (this.action == null) {
                    this.action = this.queue.poll();
                    if (this.action != null) {
                        this.action.initialize(RobotEntity.this);
                    }
                }
                RobotActions.performServer(RobotEntity.this, this.action);
            }
        }

        public void clear() {
            this.queue.clear();
            this.results.clear();
            this.lastActionId = 0;
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            ListNBT queueTag = new ListNBT();
            for (AbstractRobotAction action : this.queue) {
                queueTag.add((Object)RobotActions.serialize(action));
            }
            tag.func_218657_a(QUEUE_TAG_NAME, (INBT)queueTag);
            if (this.action != null) {
                tag.func_218657_a(ACTION_TAG_NAME, (INBT)RobotActions.serialize(this.action));
            }
            ListNBT resultsTag = new ListNBT();
            for (RobotActionProcessorResult result : this.results) {
                resultsTag.add((Object)result.serialize());
            }
            tag.func_218657_a(RESULTS_TAG_NAME, (INBT)resultsTag);
            tag.func_74768_a(LAST_ACTION_ID_TAG_NAME, this.lastActionId);
            return tag;
        }

        public void deserialize(CompoundNBT tag) {
            this.queue.clear();
            this.results.clear();
            ListNBT queueTag = tag.func_150295_c(QUEUE_TAG_NAME, 10);
            for (int i = 0; i < Math.min(queueTag.size(), 15); ++i) {
                AbstractRobotAction action = RobotActions.deserialize(queueTag.func_150305_b(i));
                if (action == null) continue;
                this.queue.add(action);
            }
            this.action = RobotActions.deserialize(tag.func_74775_l(ACTION_TAG_NAME));
            ListNBT resultsTag = tag.func_150295_c(RESULTS_TAG_NAME, 10);
            for (int i = 0; i < Math.min(resultsTag.size(), 16); ++i) {
                RobotActionProcessorResult result = new RobotActionProcessorResult(resultsTag.func_150305_b(i));
                if (result.actionId == 0) continue;
                this.results.add(result);
            }
            this.lastActionId = tag.func_74762_e(LAST_ACTION_ID_TAG_NAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addAction(AbstractRobotAction action) {
            if (RobotEntity.this.field_70170_p.func_201670_d()) {
                return false;
            }
            if (!RobotEntity.this.getVirtualMachine().isRunning()) {
                return false;
            }
            if (this.queue.size() < 15) {
                this.lastActionId = this.lastActionId + 1 & Integer.MAX_VALUE;
                action.setId(this.lastActionId);
                Queue<AbstractRobotAction> queue = this.queue;
                synchronized (queue) {
                    this.queue.add(action);
                }
                return true;
            }
            return false;
        }
    }

    private static final class RobotActionProcessorResult {
        private static final String ACTION_ID_TAG_NAME = "action_id";
        private static final String RESULT_TAG_NAME = "result";
        public int actionId;
        public RobotActionResult result;

        public RobotActionProcessorResult(int actionId, RobotActionResult result) {
            this.actionId = actionId;
            this.result = result;
        }

        public RobotActionProcessorResult(CompoundNBT tag) {
            this.deserialize(tag);
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a(ACTION_ID_TAG_NAME, this.actionId);
            NBTUtils.putEnum(tag, RESULT_TAG_NAME, this.result);
            return tag;
        }

        public void deserialize(CompoundNBT tag) {
            this.actionId = tag.func_74762_e(ACTION_ID_TAG_NAME);
            this.result = NBTUtils.getEnum(tag, RESULT_TAG_NAME, RobotActionResult.class);
        }
    }

    public final class AnimationState {
        private static final float TOP_IDLE_Y = -0.125f;
        private static final float BASE_IDLE_Y = -0.0625f;
        private static final float TRANSLATION_SPEED = 0.005f;
        private static final float ROTATION_SPEED = 1.0f;
        private static final float MAX_ROTATION = 5.0f;
        private static final float MIN_ROTATION_SPEED = 0.055f;
        private static final float MAX_ROTATION_SPEED = 0.06f;
        private static final float HOVER_ANIMATION_SPEED = 0.01f;
        public float topRenderOffsetY = -0.125f;
        public float baseRenderOffsetY = -0.0625f;
        public float topRenderRotationY;
        public float topRenderTargetRotationY;
        public float topRenderRotationSpeed;
        public float topRenderHover = -(this.hashCode() & 0xFFFF);

        public void update(float deltaTime, Random random) {
            if (RobotEntity.this.getVirtualMachine().isRunning() || RobotEntity.this.actionProcessor.hasQueuedActions()) {
                this.topRenderHover += deltaTime * 0.01f;
                float topOffsetY = MathHelper.func_76126_a((float)this.topRenderHover) / 32.0f;
                this.topRenderOffsetY = RobotEntity.lerpClamped(this.topRenderOffsetY, topOffsetY, deltaTime * 0.005f);
                this.baseRenderOffsetY = RobotEntity.lerpClamped(this.baseRenderOffsetY, topOffsetY, deltaTime * 0.005f);
                this.topRenderRotationY = RobotEntity.lerpClamped(this.topRenderRotationY, this.topRenderTargetRotationY, deltaTime * this.topRenderRotationSpeed);
                if (this.topRenderRotationY == this.topRenderTargetRotationY) {
                    this.topRenderTargetRotationY = RobotEntity.remapFrom01To(random.nextFloat(), -5.0f, 5.0f);
                    this.topRenderRotationSpeed = RobotEntity.remapFrom01To(random.nextFloat(), 0.055f, 0.06f);
                }
            } else {
                this.topRenderOffsetY = RobotEntity.lerpClamped(this.topRenderOffsetY, -0.125f, deltaTime * 0.005f * 2.0f);
                this.baseRenderOffsetY = RobotEntity.lerpClamped(this.baseRenderOffsetY, -0.0625f, deltaTime * 0.005f);
                this.topRenderRotationY = RobotEntity.lerpClamped(this.topRenderRotationY, 0.0f, deltaTime * 1.0f);
            }
        }
    }
}

