/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity.robot;

import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.common.entity.Entities;
import li.cil.oc2.common.entity.RobotEntity;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.MovementDirection;
import li.cil.oc2.common.entity.robot.RobotActionResult;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.util.NBTUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public final class RobotMovementAction
extends AbstractRobotAction {
    public static final double TARGET_EPSILON = 1.0E-4;
    private static final float MOVEMENT_SPEED = 0.05f;
    private static final String DIRECTION_TAG_NAME = "direction";
    private static final String ORIGIN_TAG_NAME = "origin";
    private static final String START_TAG_NAME = "start";
    private static final String TARGET_TAG_NAME = "target";
    private MovementDirection direction;
    @Nullable
    private BlockPos origin;
    @Nullable
    private BlockPos start;
    @Nullable
    private BlockPos target;
    @Nullable
    private Vector3d targetPos;

    public RobotMovementAction(MovementDirection direction) {
        super(RobotActions.MOVEMENT);
        this.direction = direction.resolve();
    }

    RobotMovementAction(CompoundNBT tag) {
        super(RobotActions.MOVEMENT);
        this.deserialize(tag);
    }

    public static Vector3d getTargetPositionInBlock(BlockPos position) {
        return Vector3d.func_237492_c_((Vector3i)position).func_72441_c(0.0, (double)(0.5f * (1.0f - ((EntityType)Entities.ROBOT.get()).func_220344_i())), 0.0);
    }

    public static void moveTowards(RobotEntity robot, Vector3d targetPosition) {
        Vector3d delta = targetPosition.func_178788_d(robot.func_213303_ch());
        if (delta.func_189985_c() > 0.002500000176951289) {
            delta = delta.func_72432_b().func_186678_a((double)0.05f);
        }
        robot.func_213315_a(MoverType.SELF, delta);
    }

    @Override
    public void initialize(RobotEntity robot) {
        if (this.origin == null || this.start == null || this.target == null) {
            this.target = this.start = (this.origin = robot.func_233580_cy_());
            switch (this.direction) {
                case UPWARD: {
                    this.target = this.target.func_177972_a(Direction.UP);
                    break;
                }
                case DOWNWARD: {
                    this.target = this.target.func_177972_a(Direction.DOWN);
                    break;
                }
                case FORWARD: {
                    this.target = this.target.func_177972_a(robot.func_174811_aO());
                    break;
                }
                case BACKWARD: {
                    this.target = this.target.func_177972_a(robot.func_174811_aO().func_176734_d());
                }
            }
        }
        this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
        robot.func_184212_Q().func_187227_b(RobotEntity.TARGET_POSITION, (Object)this.target);
    }

    @Override
    public RobotActionResult perform(RobotEntity robot) {
        if (this.targetPos == null) {
            throw new IllegalStateException();
        }
        this.validateTarget(robot);
        this.moveAndResolveCollisions(robot);
        if (robot.func_213303_ch().func_72436_e(this.targetPos) < 1.0E-4) {
            if (Objects.equals(this.target, this.origin)) {
                return RobotActionResult.FAILURE;
            }
            return RobotActionResult.SUCCESS;
        }
        return RobotActionResult.INCOMPLETE;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        NBTUtils.putEnum(tag, DIRECTION_TAG_NAME, this.direction);
        if (this.origin != null) {
            tag.func_218657_a(ORIGIN_TAG_NAME, (INBT)NBTUtil.func_186859_a((BlockPos)this.origin));
        }
        if (this.start != null) {
            tag.func_218657_a(START_TAG_NAME, (INBT)NBTUtil.func_186859_a((BlockPos)this.start));
        }
        if (this.target != null) {
            tag.func_218657_a(TARGET_TAG_NAME, (INBT)NBTUtil.func_186859_a((BlockPos)this.target));
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.direction = NBTUtils.getEnum(tag, DIRECTION_TAG_NAME, MovementDirection.class);
        if (this.direction == null) {
            this.direction = MovementDirection.FORWARD;
        }
        this.direction = this.direction.resolve();
        if (tag.func_150297_b(ORIGIN_TAG_NAME, 10)) {
            this.origin = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(ORIGIN_TAG_NAME));
        }
        if (tag.func_150297_b(START_TAG_NAME, 10)) {
            this.start = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(START_TAG_NAME));
        }
        if (tag.func_150297_b(TARGET_TAG_NAME, 10)) {
            this.target = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l(TARGET_TAG_NAME));
            this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
        }
    }

    private void moveAndResolveCollisions(RobotEntity robot) {
        RobotMovementAction.moveTowards(robot, this.targetPos);
        boolean didCollide = robot.field_70123_F || robot.field_70124_G;
        long gameTime = robot.field_70170_p.func_82737_E();
        if (didCollide && !robot.field_70170_p.func_201670_d() && robot.getLastPistonMovement() < gameTime - 1L) {
            BlockPos newStart = this.target;
            this.target = this.start;
            this.start = newStart;
            this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
            robot.func_184212_Q().func_187227_b(RobotEntity.TARGET_POSITION, (Object)this.target);
        }
    }

    private void validateTarget(RobotEntity robot) {
        int deltaTarget;
        BlockPos currentPosition = robot.func_233580_cy_();
        if (Objects.equals(currentPosition, this.start) || Objects.equals(currentPosition, this.target)) {
            return;
        }
        BlockPos fromStart = currentPosition.func_177973_b((Vector3i)this.start);
        BlockPos fromTarget = currentPosition.func_177973_b((Vector3i)this.target);
        int deltaStart = fromStart.func_177958_n() + fromStart.func_177956_o() + fromStart.func_177952_p();
        if (deltaStart < (deltaTarget = fromTarget.func_177958_n() + fromTarget.func_177956_o() + fromTarget.func_177952_p())) {
            this.start = currentPosition;
            this.target = this.target.func_177971_a((Vector3i)fromStart);
        } else {
            this.start = this.start.func_177971_a((Vector3i)fromTarget);
            this.target = currentPosition;
        }
        this.targetPos = RobotMovementAction.getTargetPositionInBlock(this.target);
        robot.func_184212_Q().func_187227_b(RobotEntity.TARGET_POSITION, (Object)this.target);
    }
}

