/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.entity.robot;

import javax.annotation.Nullable;
import li.cil.oc2.common.entity.RobotEntity;
import li.cil.oc2.common.entity.robot.AbstractRobotAction;
import li.cil.oc2.common.entity.robot.RobotActionResult;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.entity.robot.RotationDirection;
import li.cil.oc2.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public final class RobotRotationAction
extends AbstractRobotAction {
    public static final float TARGET_EPSILON = 1.0E-4f;
    private static final float ROTATION_SPEED = 4.5f;
    private static final String DIRECTION_TAG_NAME = "direction";
    private static final String TARGET_TAG_NAME = "start";
    private RotationDirection direction;
    @Nullable
    private Direction target;

    public RobotRotationAction(RotationDirection direction) {
        super(RobotActions.ROTATION);
        this.direction = direction.resolve();
    }

    RobotRotationAction(CompoundNBT tag) {
        super(RobotActions.ROTATION);
        this.deserialize(tag);
    }

    public static void rotateTowards(RobotEntity robot, Direction targetRotation) {
        robot.field_70177_z = MathHelper.func_203303_c((float)robot.field_70177_z, (float)targetRotation.func_185119_l(), (float)4.5f);
    }

    @Override
    public void initialize(RobotEntity robot) {
        if (this.target == null) {
            this.target = robot.func_174811_aO();
            switch (this.direction) {
                case LEFT: {
                    this.target = this.target.func_176735_f();
                    break;
                }
                case RIGHT: {
                    this.target = this.target.func_176746_e();
                }
            }
        }
        robot.func_184212_Q().func_187227_b(RobotEntity.TARGET_DIRECTION, (Object)this.target);
    }

    @Override
    public RobotActionResult perform(RobotEntity robot) {
        if (this.target == null) {
            throw new IllegalStateException();
        }
        RobotRotationAction.rotateTowards(robot, this.target);
        if (MathHelper.func_203301_d((float)robot.field_70177_z, (float)this.target.func_185119_l()) < 1.0E-4f) {
            return RobotActionResult.SUCCESS;
        }
        return RobotActionResult.INCOMPLETE;
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT tag = super.serialize();
        NBTUtils.putEnum(tag, DIRECTION_TAG_NAME, this.direction);
        if (this.target != null) {
            NBTUtils.putEnum(tag, TARGET_TAG_NAME, this.target);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.direction = NBTUtils.getEnum(tag, DIRECTION_TAG_NAME, RotationDirection.class);
        if (this.direction == null) {
            this.direction = RotationDirection.LEFT;
        }
        this.direction = this.direction.resolve();
        if (tag.func_150297_b(TARGET_TAG_NAME, 3)) {
            this.target = NBTUtils.getEnum(tag, TARGET_TAG_NAME, Direction.class);
        }
    }
}

