/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.data.BlockDeviceData;
import li.cil.oc2.common.bus.device.data.BlockDeviceDataRegistration;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractBlockDeviceItem
extends ModItem {
    private static final String DATA_TAG_NAME = "data";
    private final ResourceLocation defaultData;

    protected AbstractBlockDeviceItem(Item.Properties properties, ResourceLocation defaultData) {
        super(properties.func_200917_a(1));
        this.defaultData = defaultData;
    }

    protected AbstractBlockDeviceItem(ResourceLocation defaultData) {
        this(AbstractBlockDeviceItem.createProperties(), defaultData);
    }

    @Nullable
    public BlockDeviceData getData(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return null;
        }
        String registryName = ItemStackUtils.getModDataTag(stack).func_74779_i(DATA_TAG_NAME);
        ResourceLocation location = this.defaultData;
        if (!StringUtils.func_151246_b((String)registryName)) {
            try {
                location = new ResourceLocation(registryName);
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
        return (BlockDeviceData)BlockDeviceDataRegistration.REGISTRY.get().getValue(location);
    }

    public ItemStack withData(ItemStack stack, BlockDeviceData data) {
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return stack;
        }
        ResourceLocation key = BlockDeviceDataRegistration.REGISTRY.get().getKey((IForgeRegistryEntry)data);
        if (key == null) {
            return stack;
        }
        ItemStackUtils.getOrCreateModDataTag(stack).func_74778_a(DATA_TAG_NAME, key.toString());
        return stack;
    }

    public ItemStack withData(BlockDeviceData data) {
        return this.withData(new ItemStack((IItemProvider)this), data);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        BlockDeviceData data = this.getData(stack);
        if (data != null) {
            return new StringTextComponent("").func_230529_a_(super.func_200295_i(stack)).func_240702_b_(" (").func_230529_a_(data.getDisplayName()).func_240702_b_(")");
        }
        return super.func_200295_i(stack);
    }
}

