/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.TextFormatUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class AbstractStorageItem
extends ModItem {
    private static final String CAPACITY_TAG_NAME = "capacity";
    private final int defaultCapacity;

    protected AbstractStorageItem(Item.Properties properties, int defaultCapacity) {
        super(properties);
        this.defaultCapacity = defaultCapacity;
    }

    protected AbstractStorageItem(int capacity) {
        this(AbstractStorageItem.createProperties(), capacity);
    }

    public int getCapacity(ItemStack stack) {
        CompoundNBT tag = ItemStackUtils.getModDataTag(stack);
        if (!tag.func_150297_b(CAPACITY_TAG_NAME, 3)) {
            return this.defaultCapacity;
        }
        return tag.func_74762_e(CAPACITY_TAG_NAME);
    }

    public ItemStack withCapacity(ItemStack stack, int capacity) {
        ItemStackUtils.getOrCreateModDataTag(stack).func_74768_a(CAPACITY_TAG_NAME, capacity);
        return stack;
    }

    public ItemStack withCapacity(int capacity) {
        return this.withCapacity(new ItemStack((IItemProvider)this), capacity);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        int capacity = this.getCapacity(stack);
        return new StringTextComponent("").func_230529_a_(super.func_200295_i(stack)).func_240702_b_(" (").func_240702_b_(TextFormatUtils.formatSize(capacity)).func_240702_b_(")");
    }
}

