/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.data.Firmware;
import li.cil.oc2.common.bus.device.data.Firmwares;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class FlashMemoryWithExternalDataItem
extends ModItem {
    public static final String FIRMWARE_TAG_NAME = "firmware";
    private final ResourceLocation defaultData;
    @Nullable
    private String descriptionId;

    public FlashMemoryWithExternalDataItem(ResourceLocation defaultData) {
        super(FlashMemoryWithExternalDataItem.createProperties().func_200917_a(1));
        this.defaultData = defaultData;
    }

    @Nullable
    public Firmware getFirmware(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return null;
        }
        String registryName = ItemStackUtils.getModDataTag(stack).func_74779_i(FIRMWARE_TAG_NAME);
        ResourceLocation location = this.defaultData;
        if (!StringUtils.func_151246_b((String)registryName)) {
            try {
                location = new ResourceLocation(registryName);
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
        }
        return (Firmware)Firmwares.REGISTRY.get().getValue(location);
    }

    public ItemStack withFirmware(ItemStack stack, Firmware firmware) {
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return stack;
        }
        ResourceLocation key = Firmwares.REGISTRY.get().getKey((IForgeRegistryEntry)firmware);
        if (key == null) {
            return stack;
        }
        ItemStackUtils.getOrCreateModDataTag(stack).func_74778_a(FIRMWARE_TAG_NAME, key.toString());
        return stack;
    }

    public ItemStack withFirmware(Firmware firmware) {
        return this.withFirmware(new ItemStack((IItemProvider)this), firmware);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Firmware firmware = this.getFirmware(stack);
        if (firmware != null) {
            return new StringTextComponent("").func_230529_a_(super.func_200295_i(stack)).func_240702_b_(" (").func_230529_a_(firmware.getDisplayName()).func_240702_b_(")");
        }
        return super.func_200295_i(stack);
    }

    protected String func_195935_o() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.func_200697_a((String)"item", (ResourceLocation)Items.FLASH_MEMORY.getId());
        }
        return this.descriptionId;
    }
}

