/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import java.util.Objects;
import java.util.WeakHashMap;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.tileentity.NetworkConnectorTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class NetworkCableItem
extends ModItem {
    private static final WeakHashMap<ServerPlayerEntity, BlockPos> LINK_STARTS = new WeakHashMap();

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (player.func_225608_bj_()) {
            if (player instanceof ServerPlayerEntity) {
                LINK_STARTS.remove(player);
            }
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos currentPos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return super.func_195939_a(context);
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (stack.func_190926_b() || stack.func_77973_b() != this) {
            return super.func_195939_a(context);
        }
        World level = context.func_195991_k();
        TileEntity currentTileEntity = level.func_175625_s(currentPos = context.func_195995_a());
        if (!(currentTileEntity instanceof NetworkConnectorTileEntity)) {
            return super.func_195939_a(context);
        }
        if (!level.func_201670_d() && player instanceof ServerPlayerEntity) {
            BlockPos startPos = LINK_STARTS.remove(player);
            if (startPos == null || Objects.equals(startPos, currentPos)) {
                if (((NetworkConnectorTileEntity)currentTileEntity).canConnectMore()) {
                    LINK_STARTS.put((ServerPlayerEntity)player, currentPos);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(Constants.CONNECTOR_ERROR_FULL), true);
                }
            } else {
                TileEntity startTileEntity = level.func_175625_s(startPos);
                if (!(startTileEntity instanceof NetworkConnectorTileEntity)) {
                    return super.func_195939_a(context);
                }
                NetworkConnectorTileEntity connectorA = (NetworkConnectorTileEntity)startTileEntity;
                NetworkConnectorTileEntity connectorB = (NetworkConnectorTileEntity)currentTileEntity;
                NetworkConnectorTileEntity.ConnectionResult connectionResult = NetworkConnectorTileEntity.connect(connectorA, connectorB);
                switch (connectionResult) {
                    case SUCCESS: {
                        if (player.func_184812_l_()) break;
                        stack.func_190918_g(1);
                        break;
                    }
                    case FAILURE: {
                        LINK_STARTS.put((ServerPlayerEntity)player, startPos);
                        break;
                    }
                    case FAILURE_FULL: {
                        LINK_STARTS.put((ServerPlayerEntity)player, startPos);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(Constants.CONNECTOR_ERROR_FULL), true);
                        break;
                    }
                    case FAILURE_TOO_FAR: {
                        LINK_STARTS.put((ServerPlayerEntity)player, startPos);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(Constants.CONNECTOR_ERROR_TOO_FAR), true);
                        break;
                    }
                    case FAILURE_OBSTRUCTED: {
                        LINK_STARTS.put((ServerPlayerEntity)player, startPos);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(Constants.CONNECTOR_ERROR_OBSTRUCTED), true);
                    }
                }
            }
        }
        return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
    }
}

