/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.client.renderer.tileentity.RobotItemStackRenderer;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.energy.EnergyStorageItemStack;
import li.cil.oc2.common.entity.Entities;
import li.cil.oc2.common.entity.RobotEntity;
import li.cil.oc2.common.entity.robot.RobotActions;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.item.ModItem;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.TooltipUtils;
import li.cil.oc2.common.util.WorldUtils;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class RobotItem
extends ModItem {
    public RobotItem() {
        super(RobotItem.createProperties().setISTER(() -> RobotItemStackRenderer::new));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.getRobotWithFlash());
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        TooltipUtils.addEnergyConsumption(Config.robotEnergyPerTick, tooltip);
        TooltipUtils.addEntityEnergyInformation(stack, tooltip);
        TooltipUtils.addEntityInventoryInformation(stack, tooltip);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (Config.robotsUseEnergy()) {
            return new EnergyStorageItemStack(stack, Config.robotEnergyStorage, "oc2", "energy");
        }
        return null;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        Vector3d position = world.func_180495_p(pos = context.func_195995_a()).func_196953_a(new BlockItemUseContext(context)) ? Vector3d.func_237489_a_((Vector3i)pos) : Vector3d.func_237489_a_((Vector3i)pos.func_177972_a(context.func_196000_l()));
        RobotEntity robot = (RobotEntity)((EntityType)Entities.ROBOT.get()).func_200721_a(context.func_195991_k());
        robot.func_70012_b(position.field_72450_a, position.field_72448_b - (double)(robot.func_213302_cg() * 0.5f), position.field_72449_c, Direction.func_176733_a((double)context.func_195990_h()).func_176734_d().func_185119_l(), 0.0f);
        if (!world.func_226669_j_((Entity)robot)) {
            return super.func_195939_a(context);
        }
        if (!world.func_201670_d()) {
            RobotActions.initializeData(robot);
            robot.importFromItemStack(context.func_195996_i());
            world.func_217376_c((Entity)robot);
            WorldUtils.playSound((IWorld)world, new BlockPos(position), SoundType.field_185852_e, SoundType::func_185841_e);
            if (!context.func_195999_j().func_184812_l_()) {
                context.func_195996_i().func_190918_g(1);
            }
        }
        context.func_195999_j().func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    private ItemStack getRobotWithFlash() {
        ItemStack robot = new ItemStack((IItemProvider)this);
        CompoundNBT itemsTag = NBTUtils.getOrCreateChildTag(robot.func_196082_o(), "oc2", "items");
        itemsTag.func_218657_a(DeviceTypes.FLASH_MEMORY.getRegistryName().toString(), (INBT)NBTUtils.makeInventoryTag(new ItemStack((IItemProvider)Items.FLASH_MEMORY_CUSTOM.get())));
        return robot;
    }
}

