/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network;

import java.util.function.Consumer;
import li.cil.oc2.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageUtils {
    public static <T extends TileEntity> void withNearbyServerTileEntityAt(NetworkEvent.Context context, BlockPos pos, Class<T> type, Consumer<T> callback) {
        ServerPlayerEntity player = context.getSender();
        if (player == null || !pos.func_218137_a((IPosition)player.func_213303_ch(), 8.0)) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        TileEntity tileEntity = WorldUtils.getBlockEntityIfChunkExists((IWorld)world, pos);
        if (type.isInstance(tileEntity)) {
            callback.accept(tileEntity);
        }
    }

    public static <T extends Entity> void withServerEntity(NetworkEvent.Context context, int id, Class<T> type, Consumer<T> callback) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        Entity entity = world.func_73045_a(id);
        if (type.isInstance(entity)) {
            callback.accept(entity);
        }
    }

    public static <T extends Entity> void withNearbyServerEntity(NetworkEvent.Context context, int id, Class<T> type, Consumer<T> callback) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        Entity entity = world.func_73045_a(id);
        if (type.isInstance(entity) && entity.func_233562_a_((Entity)player, 8.0)) {
            callback.accept(entity);
        }
    }

    public static <T extends TileEntity> void withClientTileEntityAt(BlockPos pos, Class<T> type, Consumer<T> callback) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (type.isInstance(tileEntity)) {
            callback.accept(tileEntity);
        }
    }

    public static <T extends Entity> void withClientEntity(int id, Class<T> type, Consumer<T> callback) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(id);
        if (type.isInstance(entity)) {
            callback.accept(entity);
        }
    }
}

