/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMessage {
    protected static final Logger LOGGER = LogManager.getLogger();

    protected AbstractMessage() {
    }

    protected AbstractMessage(PacketBuffer buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handleMessage(AbstractMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        message.handleMessage(contextSupplier);
        return true;
    }

    public abstract void fromBytes(PacketBuffer var1);

    public abstract void toBytes(PacketBuffer var1);

    protected void handleMessage(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> this.handleMessage(context));
    }

    protected void handleMessage(NetworkEvent.Context context) {
        throw new NotImplementedException("Message implements neither asynchronous nor synchronous handleMessage() method.");
    }
}

