/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import li.cil.oc2.common.network.MessageUtils;
import li.cil.oc2.common.network.message.AbstractMessage;
import li.cil.oc2.common.tileentity.BusCableTileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class BusInterfaceNameMessage
extends AbstractMessage {
    protected BlockPos pos;
    protected Direction side;
    protected String value;

    protected BusInterfaceNameMessage(BusCableTileEntity tileEntity, Direction side, String value) {
        this.pos = tileEntity.func_174877_v();
        this.side = side;
        this.value = value;
    }

    protected BusInterfaceNameMessage(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.side = (Direction)buffer.func_179257_a(Direction.class);
        this.value = buffer.func_150789_c(32);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_179249_a((Enum)this.side);
        buffer.func_211400_a(this.value, 32);
    }

    public static final class ToServer
    extends BusInterfaceNameMessage {
        public ToServer(BusCableTileEntity tileEntity, Direction side, String value) {
            super(tileEntity, side, value);
        }

        public ToServer(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        protected void handleMessage(NetworkEvent.Context context) {
            MessageUtils.withNearbyServerTileEntityAt(context, this.pos, BusCableTileEntity.class, tileEntity -> tileEntity.setInterfaceName(this.side, this.value));
        }
    }

    public static final class ToClient
    extends BusInterfaceNameMessage {
        public ToClient(BusCableTileEntity tileEntity, Direction side, String value) {
            super(tileEntity, side, value);
        }

        public ToClient(PacketBuffer buffer) {
            super(buffer);
        }

        @Override
        protected void handleMessage(NetworkEvent.Context context) {
            MessageUtils.withClientTileEntityAt(this.pos, BusCableTileEntity.class, tileEntity -> tileEntity.setInterfaceName(this.side, this.value));
        }
    }
}

