/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import li.cil.oc2.client.gui.FileChooserScreen;
import li.cil.oc2.common.network.message.AbstractMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExportedFileMessage
extends AbstractMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private String name;
    private byte[] data;

    public ExportedFileMessage(String name, byte[] data) {
        this.name = name;
        this.data = data;
    }

    public ExportedFileMessage(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.name = buffer.func_218666_n();
        this.data = buffer.func_179251_a();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_180714_a(this.name);
        buffer.func_179250_a(this.data);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        FileChooserScreen.openFileChooserForSave(this.name, path -> {
            try {
                Files.write(path, this.data, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        });
    }
}

