/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.util.ArrayList;
import li.cil.oc2.common.network.MessageUtils;
import li.cil.oc2.common.network.message.AbstractMessage;
import li.cil.oc2.common.tileentity.NetworkConnectorTileEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public final class NetworkConnectorConnectionsMessage
extends AbstractMessage {
    private BlockPos pos;
    private ArrayList<BlockPos> connectedPositions;

    public NetworkConnectorConnectionsMessage(NetworkConnectorTileEntity connector) {
        this.pos = connector.func_174877_v();
        this.connectedPositions = new ArrayList<BlockPos>(connector.getConnectedPositions());
    }

    public NetworkConnectorConnectionsMessage(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.connectedPositions = new ArrayList();
        int positionCount = buffer.func_150792_a();
        for (int i = 0; i < positionCount; ++i) {
            BlockPos pos = buffer.func_179259_c();
            this.connectedPositions.add(pos);
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_150787_b(this.connectedPositions.size());
        for (BlockPos pos : this.connectedPositions) {
            buffer.func_179255_a(pos);
        }
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        MessageUtils.withClientTileEntityAt(this.pos, NetworkConnectorTileEntity.class, tileEntity -> tileEntity.setConnectedPositionsClient(this.connectedPositions));
    }
}

