/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import li.cil.oc2.client.gui.FileChooserScreen;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.AbstractMessage;
import li.cil.oc2.common.network.message.ClientCanceledImportFileMessage;
import li.cil.oc2.common.network.message.ImportedFileMessage;
import li.cil.oc2.common.util.TranslationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RequestImportedFileMessage
extends AbstractMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TranslationTextComponent FILE_TOO_LARGE_TEXT = TranslationUtils.text("message.{mod}.import_file.file_too_large");
    private int id;

    public RequestImportedFileMessage(int id) {
        this.id = id;
    }

    public RequestImportedFileMessage(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.id = buffer.func_150792_a();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_150787_b(this.id);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        FileChooserScreen.openFileChooserForLoad(new FileChooserScreen.FileChooserCallback(){

            @Override
            public void onFileSelected(Path path) {
                try {
                    String fileName = path.getFileName().toString();
                    byte[] data = Files.readAllBytes(path);
                    if (data.length > 524288) {
                        Network.INSTANCE.sendToServer((Object)new ClientCanceledImportFileMessage(RequestImportedFileMessage.this.id));
                        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)FILE_TOO_LARGE_TEXT.func_240700_a_(s -> s.func_240718_a_(Color.func_240743_a_((int)0xFFA0A0))), false);
                    } else {
                        Network.INSTANCE.sendToServer((Object)new ImportedFileMessage(RequestImportedFileMessage.this.id, fileName, data));
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            }

            @Override
            public void onCanceled() {
                Network.INSTANCE.sendToServer((Object)new ClientCanceledImportFileMessage(RequestImportedFileMessage.this.id));
            }
        });
    }
}

