/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.network.message;

import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.entity.RobotEntity;
import li.cil.oc2.common.network.MessageUtils;
import li.cil.oc2.common.network.message.AbstractMessage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.vm.VMRunState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public final class RobotInitializationMessage
extends AbstractMessage {
    private int entityId;
    private CommonDeviceBusController.BusState busState;
    private VMRunState runState;
    private ITextComponent bootError;
    private CompoundNBT terminal;

    public RobotInitializationMessage(RobotEntity robot) {
        this.entityId = robot.func_145782_y();
        this.busState = robot.getVirtualMachine().getBusState();
        this.runState = robot.getVirtualMachine().getRunState();
        this.bootError = robot.getVirtualMachine().getBootError();
        this.terminal = NBTSerialization.serialize(robot.getTerminal());
    }

    public RobotInitializationMessage(PacketBuffer buffer) {
        super(buffer);
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        this.entityId = buffer.func_150792_a();
        this.busState = (CommonDeviceBusController.BusState)buffer.func_179257_a(CommonDeviceBusController.BusState.class);
        this.runState = (VMRunState)buffer.func_179257_a(VMRunState.class);
        this.bootError = buffer.func_179258_d();
        this.terminal = buffer.func_150793_b();
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.func_150787_b(this.entityId);
        buffer.func_179249_a((Enum)this.busState);
        buffer.func_179249_a((Enum)this.runState);
        buffer.func_179256_a(this.bootError);
        buffer.func_150786_a(this.terminal);
    }

    @Override
    protected void handleMessage(NetworkEvent.Context context) {
        MessageUtils.withClientEntity(this.entityId, RobotEntity.class, robot -> {
            robot.getVirtualMachine().setBusStateClient(this.busState);
            robot.getVirtualMachine().setRunStateClient(this.runState);
            robot.getVirtualMachine().setBootErrorClient(this.bootError);
            NBTSerialization.deserialize(this.terminal, robot.getTerminal());
        });
    }
}

