/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BlobStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FolderName BLOBS_FOLDER_NAME = new FolderName("oc2-blobs");
    private static final Map<UUID, FileChannel> BLOBS = new HashMap<UUID, FileChannel>();
    private static Path dataDirectory;

    public static void setServer(MinecraftServer server) {
        dataDirectory = server.func_240776_a_(BLOBS_FOLDER_NAME);
        try {
            Files.createDirectories(dataDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public static void close() {
        for (FileChannel blob : BLOBS.values()) {
            try {
                blob.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        BLOBS.clear();
    }

    public static UUID allocateHandle() {
        return UUID.randomUUID();
    }

    public static UUID validateHandle(@Nullable UUID handle) {
        if (handle == null || handle.getMostSignificantBits() == 0L && handle.getLeastSignificantBits() == 0L) {
            return BlobStorage.allocateHandle();
        }
        return handle;
    }

    public static FileChannel getOrOpen(UUID handle) throws IOException {
        FileChannel blob = BLOBS.get(handle);
        if (blob != null && blob.isOpen()) {
            return blob;
        }
        Path path = dataDirectory.resolve(handle.toString());
        blob = new RandomAccessFile(path.toFile(), "rw").getChannel();
        BLOBS.put(handle, blob);
        return blob;
    }

    public static void close(UUID handle) {
        try {
            FileChannel blob = BLOBS.remove(handle);
            if (blob != null) {
                blob.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public static void delete(UUID handle) {
        BlobStorage.close(handle);
        try {
            Path path = dataDirectory.resolve(handle.toString());
            Files.deleteIfExists(path);
        }
        catch (Throwable e) {
            LOGGER.error((Object)e);
        }
    }
}

