/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.ceres.Ceres;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.StringNBT;
import org.jetbrains.annotations.Contract;

public final class NBTSerialization {
    private static final String IS_NULL_KEY = "<is_null>";
    private static final Map<Class<?>, ArraySerializer> ARRAY_SERIALIZERS = new HashMap();

    public static <T> void serialize(CompoundNBT tag, T value, Class<T> type) throws SerializationException {
        Ceres.getSerializer(type).serialize((SerializationVisitor)new Serializer(tag), type, value);
    }

    public static <T> void serialize(CompoundNBT tag, T value) throws SerializationException {
        Class<?> type = value.getClass();
        NBTSerialization.serialize(tag, value, type);
    }

    public static <T> CompoundNBT serialize(T value, Class<T> type) throws SerializationException {
        CompoundNBT tag = new CompoundNBT();
        NBTSerialization.serialize(tag, value, type);
        return tag;
    }

    public static <T> CompoundNBT serialize(T value) throws SerializationException {
        CompoundNBT tag = new CompoundNBT();
        NBTSerialization.serialize(tag, value);
        return tag;
    }

    public static <T> T deserialize(CompoundNBT tag, Class<T> type, @Nullable T into) throws SerializationException {
        return (T)Ceres.getSerializer(type).deserialize((DeserializationVisitor)new Deserializer(tag), type, into);
    }

    public static <T> T deserialize(CompoundNBT tag, Class<T> type) throws SerializationException {
        return NBTSerialization.deserialize(tag, type, null);
    }

    public static <T> T deserialize(CompoundNBT tag, T into) throws SerializationException {
        Class<?> type = into.getClass();
        return (T)NBTSerialization.deserialize(tag, type, into);
    }

    static {
        ARRAY_SERIALIZERS.put(Boolean.TYPE, new BooleanArraySerializer());
        ARRAY_SERIALIZERS.put(Byte.TYPE, new ByteArraySerializer());
        ARRAY_SERIALIZERS.put(Character.TYPE, new CharArraySerializer());
        ARRAY_SERIALIZERS.put(Short.TYPE, new ShortArraySerializer());
        ARRAY_SERIALIZERS.put(Integer.TYPE, new IntArraySerializer());
        ARRAY_SERIALIZERS.put(Long.TYPE, new LongArraySerializer());
        ARRAY_SERIALIZERS.put(Float.TYPE, new FloatArraySerializer());
        ARRAY_SERIALIZERS.put(Double.TYPE, new DoubleArraySerializer());
        ARRAY_SERIALIZERS.put(Enum.class, new EnumArraySerializer());
        ARRAY_SERIALIZERS.put(String.class, new StringArraySerializer());
        ARRAY_SERIALIZERS.put(UUID.class, new UUIDArraySerializer());
    }

    private static final class UUIDArraySerializer
    implements ArraySerializer {
        private UUIDArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            UUID[] data = (UUID[])value;
            ListNBT list = new ListNBT();
            for (UUID datum : data) {
                list.add((Object)StringNBT.func_229705_a_((String)datum.toString()));
            }
            return list;
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            ListNBT serializedData;
            UUID[] data = (UUID[])into;
            if (tag instanceof ListNBT && ((serializedData = (ListNBT)tag).isEmpty() || serializedData.func_230528_d__() == 8)) {
                if (data == null || data.length != serializedData.size()) {
                    data = new UUID[serializedData.size()];
                }
                for (int i = 0; i < serializedData.size(); ++i) {
                    data[i] = UUID.fromString(serializedData.func_150307_f(i));
                }
            }
            return data;
        }
    }

    private static final class StringArraySerializer
    implements ArraySerializer {
        private StringArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            String[] data = (String[])value;
            ListNBT list = new ListNBT();
            for (String datum : data) {
                list.add((Object)StringNBT.func_229705_a_((String)datum));
            }
            return list;
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            ListNBT serializedData;
            String[] data = (String[])into;
            if (tag instanceof ListNBT && ((serializedData = (ListNBT)tag).isEmpty() || serializedData.func_230528_d__() == 8)) {
                if (data == null || data.length != serializedData.size()) {
                    data = new String[serializedData.size()];
                }
                for (int i = 0; i < serializedData.size(); ++i) {
                    data[i] = serializedData.func_150307_f(i);
                }
            }
            return data;
        }
    }

    private static final class EnumArraySerializer
    implements ArraySerializer {
        private EnumArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            Enum[] data = (Enum[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i].ordinal();
            }
            return new IntArrayNBT(convertedData);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            Class<?> componentType = type.getComponentType();
            ?[] enumConstants = componentType.getEnumConstants();
            Enum[] data = (Enum[])into;
            if (tag instanceof IntArrayNBT) {
                int[] serializedData = ((IntArrayNBT)tag).func_150302_c();
                if (data == null || data.length != serializedData.length) {
                    data = (Enum[])Array.newInstance(componentType, serializedData.length);
                }
                for (int i = 0; i < serializedData.length; ++i) {
                    data[i] = (Enum)enumConstants[serializedData[i]];
                }
            }
            return data;
        }
    }

    private static final class DoubleArraySerializer
    implements ArraySerializer {
        private DoubleArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            double[] data = (double[])value;
            long[] convertedData = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = Double.doubleToRawLongBits(data[i]);
            }
            return new LongArrayNBT(convertedData);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            double[] data = (double[])into;
            if (tag instanceof LongArrayNBT) {
                long[] convertedData = ((LongArrayNBT)tag).func_197652_h();
                if (data == null || data.length != convertedData.length) {
                    data = new double[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = Double.longBitsToDouble(convertedData[i]);
                }
            }
            return data;
        }
    }

    private static final class FloatArraySerializer
    implements ArraySerializer {
        private FloatArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            float[] data = (float[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = Float.floatToRawIntBits(data[i]);
            }
            return new IntArrayNBT(convertedData);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            float[] data = (float[])into;
            if (tag instanceof IntArrayNBT) {
                int[] convertedData = ((IntArrayNBT)tag).func_150302_c();
                if (data == null || data.length != convertedData.length) {
                    data = new float[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = Float.intBitsToFloat(convertedData[i]);
                }
            }
            return data;
        }
    }

    private static final class LongArraySerializer
    implements ArraySerializer {
        private LongArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            return new LongArrayNBT((long[])value);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            long[] data = (long[])into;
            if (tag instanceof LongArrayNBT) {
                long[] serializedData = ((LongArrayNBT)tag).func_197652_h();
                if (data == null || data.length != serializedData.length) {
                    return serializedData;
                }
                System.arraycopy(serializedData, 0, data, 0, serializedData.length);
            }
            return data;
        }
    }

    private static final class IntArraySerializer
    implements ArraySerializer {
        private IntArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            return new IntArrayNBT((int[])value);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            int[] data = (int[])into;
            if (tag instanceof IntArrayNBT) {
                int[] serializedData = ((IntArrayNBT)tag).func_150302_c();
                if (data == null || data.length != serializedData.length) {
                    return serializedData;
                }
                System.arraycopy(serializedData, 0, data, 0, serializedData.length);
            }
            return data;
        }
    }

    private static final class ShortArraySerializer
    implements ArraySerializer {
        private ShortArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            short[] data = (short[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i];
            }
            return new IntArrayNBT(convertedData);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            short[] data = (short[])into;
            if (tag instanceof IntArrayNBT) {
                int[] convertedData = ((IntArrayNBT)tag).func_150302_c();
                if (data == null || data.length != convertedData.length) {
                    data = new short[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = (short)convertedData[i];
                }
            }
            return data;
        }
    }

    private static final class CharArraySerializer
    implements ArraySerializer {
        private CharArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            char[] data = (char[])value;
            int[] convertedData = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i];
            }
            return new IntArrayNBT(convertedData);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            char[] data = (char[])into;
            if (tag instanceof IntArrayNBT) {
                int[] convertedData = ((IntArrayNBT)tag).func_150302_c();
                if (data == null || data.length != convertedData.length) {
                    data = new char[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = (char)convertedData[i];
                }
            }
            return data;
        }
    }

    private static final class ByteArraySerializer
    implements ArraySerializer {
        private ByteArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            return new ByteArrayNBT((byte[])value);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            byte[] data = (byte[])into;
            if (tag instanceof ByteArrayNBT) {
                byte[] serializedData = ((ByteArrayNBT)tag).func_150292_c();
                if (data == null || data.length != serializedData.length) {
                    return serializedData;
                }
                System.arraycopy(serializedData, 0, data, 0, serializedData.length);
            }
            return data;
        }
    }

    private static final class BooleanArraySerializer
    implements ArraySerializer {
        private BooleanArraySerializer() {
        }

        @Override
        public INBT serialize(Object value) {
            boolean[] data = (boolean[])value;
            byte[] convertedData = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                convertedData[i] = data[i] ? (byte)1 : 0;
            }
            return new ByteArrayNBT(convertedData);
        }

        @Override
        public Object deserialize(INBT tag, Class<?> type, @Nullable Object into) {
            boolean[] data = (boolean[])into;
            if (tag instanceof ByteArrayNBT) {
                byte[] convertedData = ((ByteArrayNBT)tag).func_150292_c();
                if (data == null || data.length != convertedData.length) {
                    data = new boolean[convertedData.length];
                }
                for (int i = 0; i < convertedData.length; ++i) {
                    data[i] = convertedData[i] != 0;
                }
            }
            return data;
        }
    }

    private static interface ArraySerializer {
        public INBT serialize(Object var1);

        @Nullable
        public Object deserialize(INBT var1, Class<?> var2, @Nullable Object var3);
    }

    private static final class Deserializer
    implements DeserializationVisitor {
        private final CompoundNBT tag;

        private Deserializer(CompoundNBT tag) {
            this.tag = tag;
        }

        public boolean getBoolean(String name) {
            return this.tag.func_74767_n(name);
        }

        public byte getByte(String name) {
            return this.tag.func_74771_c(name);
        }

        public char getChar(String name) {
            return (char)this.tag.func_74762_e(name);
        }

        public short getShort(String name) {
            return this.tag.func_74765_d(name);
        }

        public int getInt(String name) {
            return this.tag.func_74762_e(name);
        }

        public long getLong(String name) {
            return this.tag.func_74763_f(name);
        }

        public float getFloat(String name) {
            return this.tag.func_74760_g(name);
        }

        public double getDouble(String name) {
            return this.tag.func_74769_h(name);
        }

        @Nullable
        public Object getObject(String name, Class<?> type, @Nullable Object into) throws SerializationException {
            if (this.isNull(name)) {
                return null;
            }
            if (!this.tag.func_74764_b(name)) {
                return into;
            }
            if (type.isArray()) {
                INBT arrayTag = this.tag.func_74781_a(name);
                assert (arrayTag != null);
                return Deserializer.getArray(arrayTag, type, into);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, this.tag.func_74779_i(name));
            }
            if (type == String.class) {
                return this.tag.func_74779_i(name);
            }
            if (type == UUID.class) {
                return this.tag.func_74775_l(name).func_186857_a(name);
            }
            CompoundNBT valueTag = this.tag.func_74775_l(name);
            return Ceres.getSerializer(type).deserialize((DeserializationVisitor)new Deserializer(valueTag), type, into);
        }

        @Nullable
        private static Object getArray(INBT tag, Class<?> type, @Nullable Object into) {
            int[] nulls;
            ListNBT listTag;
            ArrayComponentDeserializer componentDeserializer;
            Class<?> componentType = type.getComponentType();
            ArraySerializer arraySerializer = (ArraySerializer)ARRAY_SERIALIZERS.get(componentType);
            if (arraySerializer != null) {
                return arraySerializer.deserialize(tag, type, into);
            }
            if (componentType.isArray()) {
                componentDeserializer = Deserializer::getArray;
            } else {
                li.cil.ceres.api.Serializer serializer = Ceres.getSerializer(componentType);
                componentDeserializer = (n, t, i) -> serializer.deserialize((DeserializationVisitor)new Deserializer((CompoundNBT)n), t, i);
            }
            Object[] data = (Object[])into;
            int nullsIndex = 0;
            if (tag instanceof ListNBT) {
                listTag = (ListNBT)tag;
                nulls = new int[]{};
            } else if (tag instanceof CompoundNBT) {
                listTag = (ListNBT)((CompoundNBT)tag).func_74781_a("value");
                nulls = ((CompoundNBT)tag).func_74759_k("nulls");
            } else {
                return data;
            }
            if (listTag == null) {
                return data;
            }
            int length = listTag.size() + nulls.length;
            if (data == null || data.length != length) {
                data = (Object[])Array.newInstance(componentType, length);
            }
            for (int i2 = 0; i2 < length; ++i2) {
                if (nullsIndex < nulls.length && i2 == nulls[nullsIndex]) {
                    ++nullsIndex;
                    continue;
                }
                INBT itemTag = listTag.get(i2 - nullsIndex);
                if (itemTag == null) continue;
                data[i2] = componentDeserializer.deserialize(itemTag, componentType, data[i2]);
            }
            return data;
        }

        public boolean exists(String name) {
            return this.tag.func_74764_b(name);
        }

        private boolean isNull(String name) {
            return this.tag.func_74775_l(name).func_74767_n(NBTSerialization.IS_NULL_KEY);
        }

        @FunctionalInterface
        private static interface ArrayComponentDeserializer {
            @Nullable
            public Object deserialize(INBT var1, Class<?> var2, @Nullable Object var3);
        }
    }

    private static final class Serializer
    implements SerializationVisitor {
        private final CompoundNBT tag;

        private Serializer(CompoundNBT tag) {
            this.tag = tag;
        }

        public void putBoolean(String name, boolean value) {
            this.tag.func_74757_a(name, value);
        }

        public void putByte(String name, byte value) {
            this.tag.func_74774_a(name, value);
        }

        public void putChar(String name, char value) {
            this.tag.func_74768_a(name, (int)value);
        }

        public void putShort(String name, short value) {
            this.tag.func_74777_a(name, value);
        }

        public void putInt(String name, int value) {
            this.tag.func_74768_a(name, value);
        }

        public void putLong(String name, long value) {
            this.tag.func_74772_a(name, value);
        }

        public void putFloat(String name, float value) {
            this.tag.func_74776_a(name, value);
        }

        public void putDouble(String name, double value) {
            this.tag.func_74780_a(name, value);
        }

        public void putObject(String name, Class<?> type, @Nullable Object value) throws SerializationException {
            if (this.putIsNull(name, value)) {
                return;
            }
            if (type.isArray()) {
                this.tag.func_218657_a(name, this.putArray(name, type, value));
            } else if (type.isEnum()) {
                this.tag.func_74778_a(name, ((Enum)value).name());
            } else if (type == String.class) {
                this.tag.func_74778_a(name, (String)value);
            } else if (type == UUID.class) {
                CompoundNBT uuidTag = new CompoundNBT();
                uuidTag.func_186854_a(name, (UUID)value);
                this.tag.func_218657_a(name, (INBT)uuidTag);
            } else {
                CompoundNBT valueTag = new CompoundNBT();
                Ceres.getSerializer(type).serialize((SerializationVisitor)new Serializer(valueTag), type, value);
                if (!valueTag.isEmpty()) {
                    this.tag.func_218657_a(name, (INBT)valueTag);
                }
            }
        }

        private INBT putArray(String name, Class<?> type, Object value) {
            ArrayComponentSerializer componentSerializer;
            Class<?> componentType = type.getComponentType();
            ArraySerializer arraySerializer = (ArraySerializer)ARRAY_SERIALIZERS.get(componentType);
            if (arraySerializer != null) {
                return arraySerializer.serialize(value);
            }
            if (componentType.isArray()) {
                componentSerializer = (t, v) -> this.putArray(name, t, v);
            } else {
                li.cil.ceres.api.Serializer serializer = Ceres.getSerializer(componentType);
                componentSerializer = (t, v) -> {
                    CompoundNBT tag = new CompoundNBT();
                    serializer.serialize((SerializationVisitor)new Serializer(tag), t, v);
                    return tag;
                };
            }
            ListNBT listTag = new ListNBT();
            IntArrayList nullIndices = new IntArrayList();
            Object[] data = (Object[])value;
            for (int i = 0; i < data.length; ++i) {
                Object datum = data[i];
                if (datum == null) {
                    nullIndices.add(i);
                    continue;
                }
                if (datum.getClass() != componentType) {
                    throw new SerializationException(String.format("Polymorphism detected in generic array [%s]. This is not supported.", name));
                }
                listTag.add((Object)componentSerializer.serialize(componentType, datum));
            }
            if (nullIndices.isEmpty()) {
                return listTag;
            }
            CompoundNBT arrayTag = new CompoundNBT();
            arrayTag.func_218657_a("value", (INBT)listTag);
            arrayTag.func_197646_b("nulls", (List)nullIndices);
            return arrayTag;
        }

        @Contract(value="_, null -> true")
        private boolean putIsNull(String name, @Nullable Object value) {
            boolean isNull;
            boolean bl = isNull = value == null;
            if (isNull) {
                CompoundNBT nullTag = new CompoundNBT();
                nullTag.func_74757_a(NBTSerialization.IS_NULL_KEY, true);
                this.tag.func_218657_a(name, (INBT)nullTag);
            }
            return isNull;
        }

        @FunctionalInterface
        private static interface ArrayComponentSerializer {
            public INBT serialize(Class<?> var1, Object var2);
        }
    }
}

