/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;

public final class NBTToJsonConverter {
    public static JsonElement convert(@Nullable INBT tag) {
        if (tag == null) {
            return JsonNull.INSTANCE;
        }
        switch (tag.func_74732_a()) {
            case 1: {
                return new JsonPrimitive((Number)((ByteNBT)tag).func_150290_f());
            }
            case 2: {
                return new JsonPrimitive((Number)((ShortNBT)tag).func_150289_e());
            }
            case 3: {
                return new JsonPrimitive((Number)((IntNBT)tag).func_150287_d());
            }
            case 4: {
                return new JsonPrimitive((Number)((LongNBT)tag).func_150291_c());
            }
            case 5: {
                return new JsonPrimitive((Number)Float.valueOf(((FloatNBT)tag).func_150288_h()));
            }
            case 6: {
                return new JsonPrimitive((Number)((DoubleNBT)tag).func_150286_g());
            }
            case 7: {
                JsonArray json = new JsonArray();
                byte[] array = ((ByteArrayNBT)tag).func_150292_c();
                for (int i = 0; i < array.length; ++i) {
                    json.add((Number)array[i]);
                }
                return json;
            }
            case 8: {
                return new JsonPrimitive(tag.func_150285_a_());
            }
            case 9: {
                JsonArray json = new JsonArray();
                ListNBT listTag = (ListNBT)tag;
                for (INBT item : listTag) {
                    json.add(NBTToJsonConverter.convert(item));
                }
                return json;
            }
            case 10: {
                JsonObject json = new JsonObject();
                CompoundNBT compoundTag = (CompoundNBT)tag;
                for (String key : compoundTag.func_150296_c()) {
                    json.add(key, NBTToJsonConverter.convert(compoundTag.func_74781_a(key)));
                }
                return json;
            }
            case 11: {
                JsonArray json = new JsonArray();
                int[] array = ((IntArrayNBT)tag).func_150302_c();
                for (int i = 0; i < array.length; ++i) {
                    json.add((Number)array[i]);
                }
                return json;
            }
            case 12: {
                JsonArray json = new JsonArray();
                long[] array = ((LongArrayNBT)tag).func_197652_h();
                for (int i = 0; i < array.length; ++i) {
                    json.add((Number)array[i]);
                }
                return json;
            }
        }
        return JsonNull.INSTANCE;
    }
}

