/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import javax.annotation.Nullable;
import li.cil.ceres.api.DeserializationVisitor;
import li.cil.ceres.api.SerializationException;
import li.cil.ceres.api.SerializationVisitor;
import li.cil.ceres.api.Serializer;

public final class JsonArraySerializer
implements Serializer<JsonArray> {
    public void serialize(SerializationVisitor visitor, Class<JsonArray> type, Object value) throws SerializationException {
        JsonArray jsonArray = (JsonArray)value;
        visitor.putObject("value", String.class, (Object)jsonArray.toString());
    }

    @Nullable
    public JsonArray deserialize(DeserializationVisitor visitor, Class<JsonArray> type, @Nullable Object value) throws SerializationException {
        JsonArray array = (JsonArray)value;
        if (!visitor.exists("value")) {
            return array;
        }
        String jsonString = (String)visitor.getObject("value", String.class, null);
        if (jsonString == null) {
            return null;
        }
        if (array == null) {
            array = new JsonArray();
        }
        while (array.size() > 0) {
            array.remove(array.size() - 1);
        }
        array.addAll(new JsonParser().parse(jsonString).getAsJsonArray());
        return array;
    }
}

