/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.serialization.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.UUID;
import li.cil.oc2.common.bus.RPCDeviceBusAdapter;

public final class MessageJsonDeserializer
implements JsonDeserializer<RPCDeviceBusAdapter.Message> {
    public RPCDeviceBusAdapter.Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Object messageData;
        String messageType;
        JsonObject jsonObject = json.getAsJsonObject();
        switch (messageType = jsonObject.get("type").getAsString()) {
            case "list": {
                messageData = null;
                break;
            }
            case "methods": {
                messageData = UUID.fromString(jsonObject.getAsJsonPrimitive("data").getAsString());
                break;
            }
            case "invoke": {
                messageData = context.deserialize((JsonElement)jsonObject.getAsJsonObject("data"), RPCDeviceBusAdapter.MethodInvocation.class);
                break;
            }
            default: {
                throw new JsonParseException("unknown message type");
            }
        }
        return new RPCDeviceBusAdapter.Message(messageType, messageData);
    }
}

