/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractTileEntity
extends TileEntity {
    private final Runnable onWorldUnloaded = this::onWorldUnloaded;
    private final HashMap<CapabilityCacheKey, LazyOptional<?>> capabilityCache = new HashMap();
    private boolean needsWorldUnloadEvent;

    protected AbstractTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(final Capability<T> capability, @Nullable Direction side) {
        LazyOptional value;
        if (this.func_145837_r()) {
            return LazyOptional.empty();
        }
        CapabilityCacheKey key = new CapabilityCacheKey(capability, side);
        if (this.capabilityCache.containsKey(key)) {
            value = this.capabilityCache.get(key);
        } else {
            final ArrayList list = new ArrayList();
            this.collectCapabilities(new CapabilityCollector(){

                public <TOffered> void offer(Capability<TOffered> offeredCapability, TOffered instance) {
                    if (offeredCapability == capability) {
                        list.add(instance);
                    }
                }
            }, side);
            if (!list.isEmpty()) {
                Object instance = list.get(0);
                value = LazyOptional.of(() -> instance);
            } else {
                value = super.getCapability(capability, side);
            }
            if (value.isPresent()) {
                this.capabilityCache.put(key, value);
                value.addListener(optional -> this.capabilityCache.remove(key, optional));
            }
        }
        return value.cast();
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.func_201670_d()) {
            this.loadClient();
        } else {
            this.loadServer();
            if (this.needsWorldUnloadEvent) {
                ServerScheduler.scheduleOnUnload((IWorld)this.field_145850_b, this.onWorldUnloaded);
            }
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onUnload();
    }

    public void onWorldUnloaded() {
        this.invalidateCaps();
        this.onUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onUnload();
    }

    protected <T> void invalidateCapability(Capability<T> capability, @Nullable Direction direction) {
        CapabilityCacheKey key = new CapabilityCacheKey(capability, direction);
        LazyOptional<?> value = this.capabilityCache.get(key);
        if (value != null) {
            value.invalidate();
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> capability : new ArrayList(this.capabilityCache.values())) {
            capability.invalidate();
        }
    }

    protected void onUnload() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            this.unloadServer();
            ServerScheduler.cancelOnUnload((IWorld)this.field_145850_b, this.onWorldUnloaded);
        }
    }

    protected void setNeedsWorldUnloadEvent() {
        this.needsWorldUnloadEvent = true;
    }

    protected void collectCapabilities(CapabilityCollector collector, @Nullable Direction direction) {
    }

    protected void loadClient() {
    }

    protected void loadServer() {
    }

    protected void unloadServer() {
    }

    private static final class CapabilityCacheKey {
        public final Capability<?> capability;
        @Nullable
        public final Direction direction;

        public CapabilityCacheKey(Capability<?> capability, @Nullable Direction direction) {
            this.capability = capability;
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CapabilityCacheKey that = (CapabilityCacheKey)o;
            return this.capability.equals(that.capability) && this.direction == that.direction;
        }

        public int hashCode() {
            return Objects.hash(this.capability, this.direction);
        }
    }

    @FunctionalInterface
    protected static interface CapabilityCollector {
        public <T> void offer(Capability<T> var1, T var2);
    }
}

