/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.block.BusCableBlock;
import li.cil.oc2.common.bus.TileEntityDeviceBusElement;
import li.cil.oc2.common.bus.device.rpc.TypeNameRPCDevice;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.BusCableFacadeMessage;
import li.cil.oc2.common.network.message.BusInterfaceNameMessage;
import li.cil.oc2.common.tileentity.AbstractTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.ItemStackUtils;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class BusCableTileEntity
extends AbstractTileEntity {
    private static final String BUS_ELEMENT_TAG_NAME = "busElement";
    private static final String INTERFACE_NAMES_TAG_NAME = "interfaceNames";
    private static final String FACADE_TAG_NAME = "facade";
    private final TileEntityDeviceBusElement busElement = new BusCableBusElement();
    private final String[] interfaceNames = new String[Constants.BLOCK_FACE_COUNT];
    private ItemStack facade = ItemStack.field_190927_a;

    public BusCableTileEntity() {
        super((TileEntityType)TileEntities.BUS_CABLE_TILE_ENTITY.get());
    }

    public String getInterfaceName(Direction side) {
        String interfaceName = this.interfaceNames[side.func_176745_a()];
        return interfaceName == null ? "" : interfaceName;
    }

    public void setInterfaceName(Direction side, String name) {
        String validatedName = BusCableTileEntity.validateName(name);
        if (Objects.equals(validatedName, this.interfaceNames[side.func_176745_a()])) {
            return;
        }
        this.interfaceNames[side.func_176745_a()] = validatedName;
        if (!this.field_145850_b.func_201670_d()) {
            BusInterfaceNameMessage.ToClient message = new BusInterfaceNameMessage.ToClient(this, side, this.interfaceNames[side.func_176745_a()]);
            Network.sendToClientsTrackingTileEntity(message, this);
            this.handleNeighborChanged(this.func_174877_v().func_177972_a(side));
        }
    }

    public FacadeType getFacadeType(ItemStack stack) {
        return this.getFacadeType(ItemStackUtils.getBlockState(stack));
    }

    public FacadeType getFacadeType(@Nullable BlockState state) {
        if (state == null) {
            return FacadeType.NOT_A_BLOCK;
        }
        if (state.func_185901_i() != BlockRenderType.MODEL || !state.func_200015_d((IBlockReader)this.field_145850_b, this.func_174877_v()) || state.func_177230_c().hasTileEntity(state)) {
            return FacadeType.INVALID_BLOCK;
        }
        return FacadeType.VALID_BLOCK;
    }

    public ItemStack getFacade() {
        return this.facade;
    }

    public void setFacade(ItemStack stack) {
        BlockState facadeState = ItemStackUtils.getBlockState(stack);
        if (this.getFacadeType(facadeState) != FacadeType.VALID_BLOCK) {
            stack = ItemStack.field_190927_a;
        }
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.facade)) {
            return;
        }
        this.facade = stack.func_77946_l();
        this.facade.func_190920_e(1);
        BusCableBlock.setHasFacade(this.field_145850_b, this.func_174877_v(), this.func_195044_w(), facadeState, true);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        if (!this.field_145850_b.func_201670_d()) {
            BusCableFacadeMessage message = new BusCableFacadeMessage(this.func_174877_v(), this.facade);
            Network.sendToClientsTrackingTileEntity(message, this);
        }
    }

    public void removeFacade() {
        BlockState facadeState = ItemStackUtils.getBlockState(this.facade);
        this.facade = ItemStack.field_190927_a;
        BusCableBlock.setHasFacade(this.field_145850_b, this.func_174877_v(), this.func_195044_w(), facadeState, false);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        if (!this.field_145850_b.func_201670_d()) {
            BusCableFacadeMessage message = new BusCableFacadeMessage(this.func_174877_v(), this.facade);
            Network.sendToClientsTrackingTileEntity(message, this);
        }
    }

    public void handleNeighborChanged(BlockPos pos) {
        this.busElement.handleNeighborChanged(pos);
    }

    public void handleConnectivityChanged(@Nullable Direction side) {
        if (side == null) {
            this.busElement.scheduleScan();
        } else {
            this.setInterfaceName(side, "");
            this.invalidateCapability(Capabilities.DEVICE_BUS_ELEMENT, side);
            this.handleNeighborChanged(this.func_174877_v().func_177972_a(side));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.busElement.scheduleScan();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a(INTERFACE_NAMES_TAG_NAME, (INBT)this.serializeInterfaceNames());
        tag.func_218657_a(FACADE_TAG_NAME, (INBT)this.facade.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeInterfaceNames(tag.func_150295_c(INTERFACE_NAMES_TAG_NAME, 8));
        this.setFacade(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(FACADE_TAG_NAME)));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a(BUS_ELEMENT_TAG_NAME, (INBT)this.busElement.save());
        tag.func_218657_a(INTERFACE_NAMES_TAG_NAME, (INBT)this.serializeInterfaceNames());
        tag.func_218657_a(FACADE_TAG_NAME, (INBT)this.facade.serializeNBT());
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.busElement.load(tag.func_74775_l(BUS_ELEMENT_TAG_NAME));
        this.deserializeInterfaceNames(tag.func_150295_c(INTERFACE_NAMES_TAG_NAME, 8));
        this.facade = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(FACADE_TAG_NAME));
    }

    @Override
    protected void collectCapabilities(AbstractTileEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (BusCableBlock.getConnectionType(this.func_195044_w(), direction) != BusCableBlock.ConnectionType.NONE) {
            collector.offer(Capabilities.DEVICE_BUS_ELEMENT, this.busElement);
        }
    }

    @Override
    protected void loadServer() {
        super.loadServer();
        this.busElement.initialize();
    }

    private ListNBT serializeInterfaceNames() {
        ListNBT tag = new ListNBT();
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            tag.add((Object)StringNBT.func_229705_a_((String)this.getInterfaceName(Direction.func_82600_a((int)i))));
        }
        return tag;
    }

    private void deserializeInterfaceNames(ListNBT tag) {
        for (int i = 0; i < Constants.BLOCK_FACE_COUNT; ++i) {
            String name = tag.func_150307_f(i).trim();
            this.interfaceNames[i] = name.substring(0, Math.min(32, name.length()));
        }
    }

    private static String validateName(String name) {
        String trimmed = name.trim();
        return trimmed.length() > 32 ? trimmed.substring(0, 32) : trimmed;
    }

    private final class BusCableBusElement
    extends TileEntityDeviceBusElement {
        public BusCableBusElement() {
            super(BusCableTileEntity.this);
        }

        @Override
        public boolean canScanContinueTowards(@Nullable Direction direction) {
            BusCableBlock.ConnectionType connectionType = BusCableBlock.getConnectionType(BusCableTileEntity.this.func_195044_w(), direction);
            return connectionType == BusCableBlock.ConnectionType.CABLE || connectionType == BusCableBlock.ConnectionType.INTERFACE;
        }

        @Override
        public boolean canDetectDevicesTowards(@Nullable Direction direction) {
            BusCableBlock.ConnectionType connectionType = BusCableBlock.getConnectionType(BusCableTileEntity.this.func_195044_w(), direction);
            return connectionType == BusCableBlock.ConnectionType.INTERFACE;
        }

        @Override
        protected void collectSyntheticDevices(World world, BlockPos pos, @Nullable Direction direction, HashSet<BlockDeviceInfo> devices) {
            String interfaceName;
            super.collectSyntheticDevices(world, pos, direction, devices);
            if (direction != null && !StringUtils.func_151246_b((String)(interfaceName = BusCableTileEntity.this.interfaceNames[direction.func_176745_a()]))) {
                devices.add(new BlockDeviceInfo(null, new TypeNameRPCDevice(interfaceName)));
            }
        }

        @Override
        public double getEnergyConsumption() {
            return super.getEnergyConsumption() + Config.busCableEnergyPerTick + (double)BusCableBlock.getInterfaceCount(BusCableTileEntity.this.func_195044_w()) * Config.busInterfaceEnergyPerTick;
        }
    }

    public static enum FacadeType {
        NOT_A_BLOCK,
        INVALID_BLOCK,
        VALID_BLOCK;

    }
}

