/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.tileentity.AbstractTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public final class ChargerTileEntity
extends AbstractTileEntity
implements ITickableTileEntity,
NamedDevice {
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.chargerEnergyStorage);
    private boolean isCharging;

    ChargerTileEntity() {
        super((TileEntityType)TileEntities.CHARGER_TILE_ENTITY.get());
    }

    public void func_73660_a() {
        this.isCharging = false;
        this.chargeBlock();
        this.chargeEntities();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
    }

    @Callback
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public Collection<String> getDeviceTypeNames() {
        return Collections.singletonList("charger");
    }

    @Override
    protected void collectCapabilities(AbstractTileEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.ENERGY_STORAGE, this.energy);
    }

    private void chargeBlock() {
        if (this.energy.getEnergyStored() == 0) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
        if (tileEntity != null) {
            this.chargeCapabilityProvider((ICapabilityProvider)tileEntity);
        }
    }

    private void chargeEntities() {
        if (this.energy.getEnergyStored() == 0) {
            return;
        }
        List entities = this.field_145850_b.func_175674_a((Entity)null, new AxisAlignedBB(this.func_174877_v().func_177984_a()), null);
        for (Entity entity : entities) {
            this.chargeCapabilityProvider((ICapabilityProvider)entity);
        }
    }

    private void chargeCapabilityProvider(ICapabilityProvider capabilityProvider) {
        capabilityProvider.getCapability(Capabilities.ENERGY_STORAGE, Direction.DOWN).ifPresent(this::charge);
        capabilityProvider.getCapability(Capabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(this::chargeItems);
    }

    private void chargeItems(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            stack.getCapability(Capabilities.ENERGY_STORAGE).ifPresent(this::charge);
        }
    }

    private void charge(IEnergyStorage energyStorage) {
        int amount = Math.min(this.energy.getEnergyStored(), Config.chargerEnergyPerTick);
        if (this.energy.extractEnergy(energyStorage.receiveEnergy(amount, false), false) > 0) {
            this.isCharging = true;
        }
    }
}

