/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.DeviceBusElement;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.DeviceTypes;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.api.capabilities.TerminalUserProvider;
import li.cil.oc2.client.audio.LoopingSoundManager;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.ComputerBlock;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.bus.TileEntityDeviceBusController;
import li.cil.oc2.common.bus.TileEntityDeviceBusElement;
import li.cil.oc2.common.bus.device.util.BlockDeviceInfo;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.ComputerInventoryContainer;
import li.cil.oc2.common.container.ComputerTerminalContainer;
import li.cil.oc2.common.container.DeviceItemStackHandler;
import li.cil.oc2.common.energy.FixedEnergyStorage;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.ComputerBootErrorMessage;
import li.cil.oc2.common.network.message.ComputerBusStateMessage;
import li.cil.oc2.common.network.message.ComputerRunStateMessage;
import li.cil.oc2.common.network.message.ComputerTerminalOutputMessage;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.tileentity.AbstractTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.HorizontalBlockUtils;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.TerminalUtils;
import li.cil.oc2.common.vm.AbstractTerminalVMRunner;
import li.cil.oc2.common.vm.AbstractVMItemStackHandlers;
import li.cil.oc2.common.vm.AbstractVirtualMachine;
import li.cil.oc2.common.vm.BaseAddressProvider;
import li.cil.oc2.common.vm.Terminal;
import li.cil.oc2.common.vm.VMItemStackHandlers;
import li.cil.oc2.common.vm.VMRunState;
import li.cil.oc2.common.vm.VirtualMachine;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public final class ComputerTileEntity
extends AbstractTileEntity
implements ITickableTileEntity,
TerminalUserProvider {
    private static final String BUS_ELEMENT_TAG_NAME = "busElement";
    private static final String DEVICES_TAG_NAME = "devices";
    private static final String TERMINAL_TAG_NAME = "terminal";
    private static final String STATE_TAG_NAME = "state";
    private static final String ENERGY_TAG_NAME = "energy";
    private static final int MEMORY_SLOTS = 4;
    private static final int HARD_DRIVE_SLOTS = 4;
    private static final int FLASH_MEMORY_SLOTS = 1;
    private static final int CARD_SLOTS = 4;
    private static final int MAX_RUNNING_SOUND_DELAY = 40;
    private boolean hasAddedOwnDevices;
    private boolean isNeighborUpdateScheduled;
    private final Terminal terminal = new Terminal();
    private final ComputerBusElement busElement = new ComputerBusElement();
    private final ComputerItemStackHandlers deviceItems = new ComputerItemStackHandlers();
    private final FixedEnergyStorage energy = new FixedEnergyStorage(Config.computerEnergyStorage);
    private final ComputerVirtualMachine virtualMachine = new ComputerVirtualMachine(new TileEntityDeviceBusController(this.busElement, Config.computerEnergyPerTick, this), this.deviceItems::getDeviceAddressBase);
    private final Set<PlayerEntity> terminalUsers = Collections.newSetFromMap(new WeakHashMap());

    public ComputerTileEntity() {
        super((TileEntityType)TileEntities.COMPUTER_TILE_ENTITY.get());
        this.setNeedsWorldUnloadEvent();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public VMItemStackHandlers getItemStackHandlers() {
        return this.deviceItems;
    }

    public void start() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        this.virtualMachine.start();
    }

    public void stop() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        this.virtualMachine.stop();
    }

    public void openTerminalScreen(ServerPlayerEntity player) {
        ComputerTerminalContainer.createServer(this, (IEnergyStorage)this.energy, this.virtualMachine.busController, player);
    }

    public void openInventoryScreen(ServerPlayerEntity player) {
        ComputerInventoryContainer.createServer(this, (IEnergyStorage)this.energy, this.virtualMachine.busController, player);
    }

    public void addTerminalUser(PlayerEntity player) {
        this.terminalUsers.add(player);
    }

    public void removeTerminalUser(PlayerEntity player) {
        this.terminalUsers.remove(player);
    }

    @Override
    public Iterable<PlayerEntity> getTerminalUsers() {
        return this.terminalUsers;
    }

    public void handleNeighborChanged() {
        this.virtualMachine.busController.scheduleBusScan();
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (this.func_145837_r()) {
            return LazyOptional.empty();
        }
        LazyOptional<T> optional = super.getCapability(capability, side);
        if (optional.isPresent()) {
            return optional;
        }
        Direction localSide = HorizontalBlockUtils.toLocal(this.func_195044_w(), side);
        for (Device device : this.virtualMachine.busController.getDevices()) {
            LazyOptional value;
            if (!(device instanceof ICapabilityProvider) || !(value = ((ICapabilityProvider)device).getCapability(capability, localSide)).isPresent()) continue;
            return value;
        }
        return LazyOptional.empty();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        if (!this.hasAddedOwnDevices) {
            this.hasAddedOwnDevices = true;
            this.busElement.addOwnDevices();
        }
        if (this.isNeighborUpdateScheduled) {
            this.isNeighborUpdateScheduled = false;
            this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
        this.virtualMachine.tick();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.virtualMachine.state.vmAdapter.unmount();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a(TERMINAL_TAG_NAME, (INBT)NBTSerialization.serialize(this.terminal));
        tag.func_74768_a("busState", this.virtualMachine.getBusState().ordinal());
        tag.func_74768_a("runState", this.virtualMachine.getRunState().ordinal());
        tag.func_74778_a("bootError", ITextComponent.Serializer.func_150696_a((ITextComponent)this.virtualMachine.getBootError()));
        return tag;
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT tag) {
        super.handleUpdateTag(blockState, tag);
        NBTSerialization.deserialize(tag.func_74775_l(TERMINAL_TAG_NAME), this.terminal);
        this.virtualMachine.setBusStateClient(CommonDeviceBusController.BusState.values()[tag.func_74762_e("busState")]);
        this.virtualMachine.setRunStateClient(VMRunState.values()[tag.func_74762_e("runState")]);
        this.virtualMachine.setBootErrorClient((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("bootError")));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a(ENERGY_TAG_NAME, (INBT)this.energy.serializeNBT());
        tag.func_218657_a(STATE_TAG_NAME, (INBT)this.virtualMachine.serialize());
        tag.func_218657_a(TERMINAL_TAG_NAME, (INBT)NBTSerialization.serialize(this.terminal));
        tag.func_218657_a(BUS_ELEMENT_TAG_NAME, (INBT)this.busElement.save());
        tag.func_218657_a("items", (INBT)this.deviceItems.saveItems());
        tag.func_218657_a(DEVICES_TAG_NAME, (INBT)this.deviceItems.saveDevices());
        return tag;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tag) {
        super.func_230337_a_(blockState, tag);
        this.energy.deserializeNBT(tag.func_74775_l(ENERGY_TAG_NAME));
        this.virtualMachine.deserialize(tag.func_74775_l(STATE_TAG_NAME));
        NBTSerialization.deserialize(tag.func_74775_l(TERMINAL_TAG_NAME), this.terminal);
        this.busElement.load(tag.func_74775_l(BUS_ELEMENT_TAG_NAME));
        this.deviceItems.loadItems(tag.func_74775_l("items"));
        this.deviceItems.loadDevices(tag.func_74775_l(DEVICES_TAG_NAME));
    }

    public void exportToItemStack(ItemStack stack) {
        this.deviceItems.saveItems(NBTUtils.getOrCreateChildTag(stack.func_196082_o(), "BlockEntityTag", "items"));
    }

    @Override
    protected void collectCapabilities(AbstractTileEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.ITEM_HANDLER, this.deviceItems.combinedItemHandlers);
        collector.offer(Capabilities.DEVICE_BUS_ELEMENT, this.busElement);
        collector.offer(Capabilities.TERMINAL_USER_PROVIDER, this);
        if (Config.computersUseEnergy()) {
            collector.offer(Capabilities.ENERGY_STORAGE, this.energy);
        }
    }

    @Override
    protected void loadClient() {
        super.loadClient();
        this.terminal.setDisplayOnly(true);
    }

    @Override
    protected void loadServer() {
        super.loadServer();
        this.busElement.initialize();
        this.virtualMachine.state.builtinDevices.rtcMinecraft.setWorld(this.field_145850_b);
    }

    @Override
    protected void unloadServer() {
        super.unloadServer();
        this.virtualMachine.suspend();
        this.busElement.scheduleScan();
    }

    private final class ComputerVirtualMachine
    extends AbstractVirtualMachine {
        private Chunk chunk;

        private ComputerVirtualMachine(CommonDeviceBusController busController, BaseAddressProvider baseAddressProvider) {
            super(busController);
            this.state.vmAdapter.setBaseAddressProvider(baseAddressProvider);
        }

        @Override
        public void setRunStateClient(VMRunState value) {
            super.setRunStateClient(value);
            if (value == VMRunState.RUNNING) {
                if (!LoopingSoundManager.isPlaying(ComputerTileEntity.this)) {
                    LoopingSoundManager.play(ComputerTileEntity.this, (SoundEvent)SoundEvents.COMPUTER_RUNNING.get(), ComputerTileEntity.this.field_145850_b.func_201674_k().nextInt(40));
                }
            } else {
                LoopingSoundManager.stop(ComputerTileEntity.this);
            }
        }

        @Override
        public void tick() {
            if (this.chunk == null) {
                this.chunk = ComputerTileEntity.this.field_145850_b.func_175726_f(ComputerTileEntity.this.func_174877_v());
            }
            if (this.isRunning()) {
                this.chunk.func_76630_e();
            }
            super.tick();
        }

        @Override
        protected boolean consumeEnergy(int amount, boolean simulate) {
            if (!Config.computersUseEnergy()) {
                return true;
            }
            if (amount > ComputerTileEntity.this.energy.getEnergyStored()) {
                return false;
            }
            ComputerTileEntity.this.energy.extractEnergy(amount, simulate);
            return true;
        }

        @Override
        protected void stopRunnerAndReset() {
            super.stopRunnerAndReset();
            TerminalUtils.resetTerminal(ComputerTileEntity.this.terminal, output -> Network.sendToClientsTrackingChunk(new ComputerTerminalOutputMessage(ComputerTileEntity.this, (ByteBuffer)output), this.chunk));
        }

        @Override
        protected AbstractTerminalVMRunner createRunner() {
            return new ComputerVMRunner(this, ComputerTileEntity.this.terminal);
        }

        @Override
        protected void handleBusStateChanged(CommonDeviceBusController.BusState value) {
            Network.sendToClientsTrackingChunk(new ComputerBusStateMessage(ComputerTileEntity.this), this.chunk);
            if (value == CommonDeviceBusController.BusState.READY) {
                ComputerTileEntity.this.field_145850_b.func_195593_d(ComputerTileEntity.this.func_174877_v(), ComputerTileEntity.this.func_195044_w().func_177230_c());
            }
        }

        @Override
        protected void handleRunStateChanged(VMRunState value) {
            if (this.chunk != null) {
                Network.sendToClientsTrackingChunk(new ComputerRunStateMessage(ComputerTileEntity.this), this.chunk);
            }
        }

        @Override
        protected void handleBootErrorChanged(@Nullable ITextComponent value) {
            Network.sendToClientsTrackingChunk(new ComputerBootErrorMessage(ComputerTileEntity.this), this.chunk);
        }
    }

    private final class ComputerVMRunner
    extends AbstractTerminalVMRunner {
        public ComputerVMRunner(AbstractVirtualMachine virtualMachine, Terminal terminal) {
            super(virtualMachine, terminal);
        }

        @Override
        protected void sendTerminalUpdateToClient(ByteBuffer output) {
            Network.sendToClientsTrackingChunk(new ComputerTerminalOutputMessage(ComputerTileEntity.this, output), ComputerTileEntity.this.virtualMachine.chunk);
        }
    }

    private final class ComputerBusElement
    extends TileEntityDeviceBusElement {
        private static final String DEVICE_ID_TAG_NAME = "device_id";
        private final HashSet<Device> devices;
        private UUID deviceId;

        public ComputerBusElement() {
            super(ComputerTileEntity.this);
            this.devices = new HashSet();
            this.deviceId = UUID.randomUUID();
        }

        public void addOwnDevices() {
            for (BlockDeviceInfo info : this.collectDevices(ComputerTileEntity.this.field_145850_b, this.getPosition(), null)) {
                this.devices.add(info.device);
                super.addDevice(info.device);
            }
        }

        @Override
        public Optional<Collection<LazyOptional<DeviceBusElement>>> getNeighbors() {
            return super.getNeighbors().map(neighbors -> {
                ArrayList<LazyOptional> list = new ArrayList<LazyOptional>((Collection<LazyOptional>)neighbors);
                list.add(LazyOptional.of(() -> ((ComputerTileEntity)ComputerTileEntity.this).deviceItems.busElement));
                return list;
            });
        }

        @Override
        public boolean canScanContinueTowards(@Nullable Direction direction) {
            return ComputerTileEntity.this.func_195044_w().func_177229_b((Property)ComputerBlock.field_185512_D) != direction;
        }

        @Override
        public Optional<UUID> getDeviceIdentifier(Device device) {
            if (this.devices.contains(device)) {
                return Optional.of(this.deviceId);
            }
            return super.getDeviceIdentifier(device);
        }

        @Override
        public CompoundNBT save() {
            CompoundNBT tag = super.save();
            tag.func_186854_a(DEVICE_ID_TAG_NAME, this.deviceId);
            return tag;
        }

        @Override
        public void load(CompoundNBT tag) {
            super.load(tag);
            if (tag.func_186855_b(DEVICE_ID_TAG_NAME)) {
                this.deviceId = tag.func_186857_a(DEVICE_ID_TAG_NAME);
            }
        }
    }

    private final class ComputerItemStackHandlers
    extends AbstractVMItemStackHandlers {
        public ComputerItemStackHandlers() {
            super(AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.MEMORY, 4), AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.HARD_DRIVE, 4), AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.FLASH_MEMORY, 1), AbstractVMItemStackHandlers.GroupDefinition.of(DeviceTypes.CARD, 4));
        }

        @Override
        protected ItemDeviceQuery getDeviceQuery(ItemStack stack) {
            return Devices.makeQuery((TileEntity)ComputerTileEntity.this, stack);
        }

        @Override
        protected void onContentsChanged(DeviceItemStackHandler itemStackHandler, int slot) {
            super.onContentsChanged(itemStackHandler, slot);
            ComputerTileEntity.this.func_70296_d();
            ComputerTileEntity.this.isNeighborUpdateScheduled = true;
        }
    }
}

