/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.common.Config;
import li.cil.oc2.common.block.DiskDriveBlock;
import li.cil.oc2.common.bus.device.item.AbstractBlockDeviceVMDevice;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.container.TypedItemStackHandler;
import li.cil.oc2.common.item.FloppyItem;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.DiskDriveFloppyMessage;
import li.cil.oc2.common.serialization.BlobStorage;
import li.cil.oc2.common.tags.ItemTags;
import li.cil.oc2.common.tileentity.AbstractTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.LocationSupplierUtils;
import li.cil.oc2.common.util.SoundEvents;
import li.cil.oc2.common.util.ThrottledSoundEmitter;
import li.cil.sedna.api.device.BlockDevice;
import li.cil.sedna.device.block.ByteBufferBlockDevice;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DiskDriveTileEntity
extends AbstractTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_TAG_NAME = "data";
    private static final ByteBufferBlockDevice EMPTY_BLOCK_DEVICE = ByteBufferBlockDevice.create((int)0, (boolean)false);
    private final DiskDriveItemStackHandler itemHandler = new DiskDriveItemStackHandler();
    private final DiskDriveVMDevice device = new DiskDriveVMDevice();
    private final ThrottledSoundEmitter accessSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_ACCESS.get()).withMinInterval(Duration.ofSeconds(1L));
    private final ThrottledSoundEmitter insertSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_INSERT.get()).withMinInterval(Duration.ofMillis(100L));
    private final ThrottledSoundEmitter ejectSoundEmitter = new ThrottledSoundEmitter(LocationSupplierUtils.of(this), (SoundEvent)SoundEvents.FLOPPY_EJECT.get()).withMinInterval(Duration.ofMillis(100L));

    public DiskDriveTileEntity() {
        super((TileEntityType)TileEntities.DISK_DRIVE_TILE_ENTITY.get());
    }

    public VMDevice getDevice() {
        return this.device;
    }

    public boolean canInsert(ItemStack stack) {
        return !stack.func_190926_b() && ItemTags.DEVICES_FLOPPY.func_230235_a_((Object)stack.func_77973_b());
    }

    public ItemStack insert(ItemStack stack, @Nullable PlayerEntity player) {
        if (stack.func_190926_b() || !ItemTags.DEVICES_FLOPPY.func_230235_a_((Object)stack.func_77973_b())) {
            return stack;
        }
        this.eject(player);
        this.insertSoundEmitter.play();
        return this.itemHandler.insertItem(0, stack, false);
    }

    public boolean canEject() {
        return !this.itemHandler.extractItem(0, 1, true).func_190926_b();
    }

    public void eject(@Nullable PlayerEntity player) {
        ItemStack stack = this.itemHandler.extractItem(0, 1, false);
        if (!stack.func_190926_b()) {
            Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)DiskDriveBlock.field_185512_D);
            this.ejectSoundEmitter.play();
            ItemStackUtils.spawnAsEntity(this.field_145850_b, this.func_174877_v().func_177972_a(facing), stack, facing).ifPresent(entity -> {
                if (player != null) {
                    entity.func_174868_q();
                    entity.func_200217_b(player.func_110124_au());
                }
            });
        }
    }

    public ItemStack getFloppy() {
        return this.itemHandler.getStackInSlot(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setFloppyClient(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    protected void collectCapabilities(AbstractTileEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.ITEM_HANDLER, this.itemHandler);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_218657_a("items", (INBT)this.itemHandler.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("items"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("items", (INBT)this.itemHandler.serializeNBT());
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("items"));
    }

    private final class DiskDriveVMDevice
    extends AbstractBlockDeviceVMDevice<BlockDevice, TileEntity> {
        public DiskDriveVMDevice() {
            super(DiskDriveTileEntity.this);
        }

        public void updateBlockDevice(CompoundNBT tag) {
            if (this.device == null) {
                return;
            }
            if (this.blobHandle != null) {
                BlobStorage.close(this.blobHandle);
                this.blobHandle = null;
            }
            this.importFromItemStack(tag);
            try {
                this.device.setBlock(this.createBlockDevice());
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }

        public void removeBlockDevice() {
            if (this.device == null) {
                return;
            }
            if (this.blobHandle != null) {
                BlobStorage.close(this.blobHandle);
                this.blobHandle = null;
            }
            try {
                this.device.setBlock((BlockDevice)EMPTY_BLOCK_DEVICE);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }

        @Override
        protected BlockDevice createBlockDevice() throws IOException {
            ItemStack stack = DiskDriveTileEntity.this.itemHandler.getStackInSlotRaw(0);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof FloppyItem)) {
                return EMPTY_BLOCK_DEVICE;
            }
            FloppyItem item = (FloppyItem)stack.func_77973_b();
            int capacity = MathHelper.func_76125_a((int)item.getCapacity(stack), (int)0, (int)Config.maxFloppySize);
            if (capacity <= 0) {
                return EMPTY_BLOCK_DEVICE;
            }
            this.blobHandle = BlobStorage.validateHandle(this.blobHandle);
            FileChannel channel = BlobStorage.getOrOpen(this.blobHandle);
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, capacity);
            return ByteBufferBlockDevice.wrap((ByteBuffer)buffer, (boolean)false);
        }

        @Override
        protected void handleDataAccess() {
            DiskDriveTileEntity.this.accessSoundEmitter.play();
        }
    }

    private final class DiskDriveItemStackHandler
    extends TypedItemStackHandler {
        public DiskDriveItemStackHandler() {
            super(1, (ITag<Item>)ItemTags.DEVICES_FLOPPY);
        }

        public ItemStack getStackInSlotRaw(int slot) {
            return super.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            ItemStack stack = this.getStackInSlotRaw(slot);
            this.exportDeviceDataToItemStack(stack);
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && !simulate && amount > 0) {
                this.exportDeviceDataToItemStack(this.getStackInSlotRaw(0));
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (DiskDriveTileEntity.this.field_145850_b == null || DiskDriveTileEntity.this.field_145850_b.func_201670_d()) {
                return;
            }
            ItemStack stack = this.getStackInSlotRaw(slot);
            if (stack.func_190926_b()) {
                DiskDriveTileEntity.this.device.removeBlockDevice();
            } else {
                CompoundNBT tag = ItemStackUtils.getOrCreateModDataTag(stack).func_74775_l(DiskDriveTileEntity.DATA_TAG_NAME);
                DiskDriveTileEntity.this.device.updateBlockDevice(tag);
            }
            Network.sendToClientsTrackingTileEntity(new DiskDriveFloppyMessage(DiskDriveTileEntity.this), DiskDriveTileEntity.this);
        }

        private void exportDeviceDataToItemStack(ItemStack stack) {
            if (stack.func_190926_b()) {
                return;
            }
            if (DiskDriveTileEntity.this.field_145850_b == null || DiskDriveTileEntity.this.field_145850_b.func_201670_d()) {
                return;
            }
            CompoundNBT tag = new CompoundNBT();
            DiskDriveTileEntity.this.device.exportToItemStack(tag);
            ItemStackUtils.getOrCreateModDataTag(stack).func_218657_a(DiskDriveTileEntity.DATA_TAG_NAME, (INBT)tag);
        }
    }
}

