/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.client.renderer.NetworkCableRenderer;
import li.cil.oc2.common.block.NetworkConnectorBlock;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.network.Network;
import li.cil.oc2.common.network.message.NetworkConnectorConnectionsMessage;
import li.cil.oc2.common.tileentity.AbstractTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.ItemStackUtils;
import li.cil.oc2.common.util.ServerScheduler;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public final class NetworkConnectorTileEntity
extends AbstractTileEntity
implements ITickableTileEntity {
    private static final String CONNECTIONS_TAG_NAME = "connections";
    private static final String IS_OWNER_TAG_NAME = "is_owner";
    private static final int RETRY_UNLOADED_CHUNK_INTERVAL = 100;
    private static final int MAX_CONNECTION_COUNT = 2;
    private static final int MAX_CONNECTION_DISTANCE = 16;
    private static final int INITIAL_PACKET_TIME_TO_LIVE = 12;
    private static final int BYTES_PER_TICK = 3276;
    private static final int MIN_ETHERNET_FRAME_SIZE = 42;
    private static final int TTL_COST = 1;
    private final NetworkConnectorNetworkInterface networkInterface = new NetworkConnectorNetworkInterface();
    private LazyOptional<NetworkInterface> localInterface = LazyOptional.empty();
    private boolean isLocalConnectionDirty = true;
    private final HashSet<BlockPos> connectorPositions = new HashSet();
    private final HashSet<BlockPos> ownedCables = new HashSet();
    private final HashSet<BlockPos> dirtyConnectors = new HashSet();
    private final HashMap<BlockPos, NetworkConnectorTileEntity> connectors = new HashMap();

    public NetworkConnectorTileEntity() {
        super((TileEntityType)TileEntities.NETWORK_CONNECTOR_TILE_ENTITY.get());
    }

    public static ConnectionResult connect(NetworkConnectorTileEntity connectorA, NetworkConnectorTileEntity connectorB) {
        ConnectionResult result;
        BlockPos posB;
        if (connectorA == connectorB || connectorA.func_145837_r() || connectorB.func_145837_r()) {
            return ConnectionResult.FAILURE;
        }
        World world = connectorA.field_145850_b;
        if (world == null || world.func_201670_d()) {
            return ConnectionResult.FAILURE;
        }
        if (connectorB.field_145850_b != world) {
            return ConnectionResult.FAILURE;
        }
        if (!connectorA.canConnectMore() || !connectorB.canConnectMore()) {
            return ConnectionResult.FAILURE_FULL;
        }
        BlockPos posA = connectorA.func_174877_v();
        if (!posA.func_218141_a((Vector3i)(posB = connectorB.func_174877_v()), 16.0)) {
            return ConnectionResult.FAILURE_TOO_FAR;
        }
        if (NetworkConnectorTileEntity.isObstructed(world, posA, posB)) {
            return ConnectionResult.FAILURE_OBSTRUCTED;
        }
        if (connectorA.connectorPositions.add(posB)) {
            connectorA.dirtyConnectors.add(posB);
            connectorA.onConnectedPositionsChanged();
        }
        if (connectorB.connectorPositions.add(posA)) {
            connectorB.dirtyConnectors.add(posA);
            connectorB.onConnectedPositionsChanged();
        }
        if (connectorA.ownedCables.contains(posB) || connectorB.ownedCables.contains(posA)) {
            connectorA.ownedCables.add(posB);
            connectorB.ownedCables.remove(posA);
            result = ConnectionResult.ALREADY_CONNECTED;
        } else {
            connectorA.ownedCables.add(posB);
            result = ConnectionResult.SUCCESS;
        }
        connectorA.func_70296_d();
        connectorB.func_70296_d();
        return result;
    }

    public void disconnectFrom(BlockPos pos) {
        this.dirtyConnectors.remove(pos);
        this.connectors.remove(pos);
        if (this.ownedCables.remove(pos) && this.field_145850_b != null) {
            Vector3d middle = Vector3d.func_237489_a_((Vector3i)this.func_174877_v().func_177971_a((Vector3i)pos)).func_186678_a(0.5);
            ItemStackUtils.spawnAsEntity(this.field_145850_b, middle, new ItemStack((IItemProvider)Items.NETWORK_CABLE.get()));
        }
        if (!this.func_145837_r()) {
            if (this.connectorPositions.remove(pos)) {
                this.onConnectedPositionsChanged();
            }
            this.func_70296_d();
        }
    }

    public boolean canConnectMore() {
        return this.connectorPositions.size() < 2;
    }

    public Collection<BlockPos> getConnectedPositions() {
        return this.connectorPositions;
    }

    public void setLocalInterfaceChanged() {
        this.isLocalConnectionDirty = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setConnectedPositionsClient(ArrayList<BlockPos> positions) {
        this.connectorPositions.clear();
        this.connectorPositions.addAll(positions);
        NetworkCableRenderer.invalidateConnections();
    }

    public void func_73660_a() {
        byte[] frame;
        if (this.isLocalConnectionDirty) {
            this.isLocalConnectionDirty = false;
            this.resolveLocalInterface();
        }
        if (!this.dirtyConnectors.isEmpty()) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.dirtyConnectors);
            this.dirtyConnectors.clear();
            for (BlockPos connectedPosition : list) {
                this.resolveConnectedInterface(connectedPosition);
            }
        }
        NetworkInterface src = (NetworkInterface)this.localInterface.orElse((Object)NullNetworkInterface.INSTANCE);
        for (int byteBudget = 3276; (frame = src.readEthernetFrame()) != null && byteBudget > 0; byteBudget -= Math.max(frame.length, 42)) {
            this.networkInterface.writeEthernetFrame(src, frame, 12);
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        ListNBT connections = new ListNBT();
        for (BlockPos position : this.connectorPositions) {
            CompoundNBT connectionTag = NBTUtil.func_186859_a((BlockPos)position);
            connections.add((Object)connectionTag);
        }
        tag.func_218657_a(CONNECTIONS_TAG_NAME, (INBT)connections);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        ListNBT connections = tag.func_150295_c(CONNECTIONS_TAG_NAME, 10);
        for (int i = 0; i < Math.min(connections.size(), 2); ++i) {
            CompoundNBT connectionTag = connections.func_150305_b(i);
            BlockPos position = NBTUtil.func_186861_c((CompoundNBT)connectionTag);
            this.connectorPositions.add(position);
            this.dirtyConnectors.add(position);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        ListNBT connections = new ListNBT();
        for (BlockPos position : this.connectorPositions) {
            CompoundNBT connectionTag = NBTUtil.func_186859_a((BlockPos)position);
            if (this.ownedCables.contains(position)) {
                connectionTag.func_74757_a(IS_OWNER_TAG_NAME, true);
            }
            connections.add((Object)connectionTag);
        }
        tag.func_218657_a(CONNECTIONS_TAG_NAME, (INBT)connections);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        ListNBT connections = tag.func_150295_c(CONNECTIONS_TAG_NAME, 10);
        for (int i = 0; i < Math.min(connections.size(), 2); ++i) {
            CompoundNBT connectionTag = connections.func_150305_b(i);
            BlockPos position = NBTUtil.func_186861_c((CompoundNBT)connectionTag);
            this.connectorPositions.add(position);
            this.dirtyConnectors.add(position);
            if (!connectionTag.func_74767_n(IS_OWNER_TAG_NAME)) continue;
            this.ownedCables.add(position);
        }
    }

    @Override
    protected void loadClient() {
        super.loadClient();
        NetworkCableRenderer.addNetworkConnector(this);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        ArrayList<NetworkConnectorTileEntity> list = new ArrayList<NetworkConnectorTileEntity>(this.connectors.values());
        this.connectors.clear();
        for (NetworkConnectorTileEntity connector : list) {
            this.disconnectFrom(connector.func_174877_v());
            connector.disconnectFrom(this.func_174877_v());
        }
    }

    @Override
    protected void unloadServer() {
        super.unloadServer();
        BlockPos pos = this.func_174877_v();
        for (NetworkConnectorTileEntity connector : this.connectors.values()) {
            connector.connectors.remove(pos);
            if (!connector.connectorPositions.contains(pos)) continue;
            connector.dirtyConnectors.add(pos);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (Minecraft.func_238218_y_()) {
            return new AxisAlignedBB(this.func_174877_v().func_177982_a(-16, -16, -16), this.func_174877_v().func_177982_a(17, 17, 17));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    protected void collectCapabilities(AbstractTileEntity.CapabilityCollector collector, @Nullable Direction direction) {
        if (direction == NetworkConnectorBlock.getFacing(this.func_195044_w()).func_176734_d()) {
            collector.offer(Capabilities.NETWORK_INTERFACE, this.networkInterface);
        }
    }

    private void resolveLocalInterface() {
        this.localInterface = LazyOptional.empty();
        if (this.func_145837_r()) {
            return;
        }
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        Direction facing = NetworkConnectorBlock.getFacing(this.func_195044_w());
        BlockPos sourcePos = this.func_174877_v().func_177972_a(facing.func_176734_d());
        ChunkPos sourceChunk = new ChunkPos(sourcePos);
        if (!this.field_145850_b.func_217354_b(sourceChunk.field_77276_a, sourceChunk.field_77275_b)) {
            ServerScheduler.schedule((IWorld)this.field_145850_b, this::setLocalInterfaceChanged, 100);
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(sourcePos);
        if (tileEntity == null) {
            return;
        }
        this.localInterface = tileEntity.getCapability(Capabilities.NETWORK_INTERFACE, facing);
        if (this.localInterface.isPresent()) {
            this.localInterface.addListener(unused -> this.setLocalInterfaceChanged());
        }
    }

    private void resolveConnectedInterface(BlockPos connectedPosition) {
        this.connectors.remove(connectedPosition);
        if (this.func_145837_r()) {
            return;
        }
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        ChunkPos destinationChunk = new ChunkPos(connectedPosition);
        if (!this.field_145850_b.func_217354_b(destinationChunk.field_77276_a, destinationChunk.field_77275_b)) {
            ServerScheduler.schedule((IWorld)this.field_145850_b, () -> this.dirtyConnectors.add(connectedPosition), 100);
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(connectedPosition);
        if (!(tileEntity instanceof NetworkConnectorTileEntity)) {
            this.disconnectFrom(connectedPosition);
            return;
        }
        NetworkConnectorTileEntity connector = (NetworkConnectorTileEntity)tileEntity;
        if (!connectedPosition.func_218141_a((Vector3i)this.func_174877_v(), 16.0)) {
            this.disconnectFrom(connectedPosition);
            connector.disconnectFrom(this.func_174877_v());
            return;
        }
        if (NetworkConnectorTileEntity.isObstructed(this.field_145850_b, this.func_174877_v(), connectedPosition)) {
            this.disconnectFrom(connectedPosition);
            connector.disconnectFrom(this.func_174877_v());
            return;
        }
        this.connectors.put(connectedPosition, connector);
    }

    private static boolean isObstructed(World world, BlockPos a, BlockPos b) {
        Vector3d va = Vector3d.func_237489_a_((Vector3i)a);
        Vector3d vb = Vector3d.func_237489_a_((Vector3i)b);
        Vector3d ab = vb.func_178788_d(va).func_72432_b().func_186678_a(0.5);
        BlockRayTraceResult hitAB = world.func_217299_a(new RayTraceContext(va.func_178787_e(ab), vb.func_178788_d(ab), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        BlockRayTraceResult hitBA = world.func_217299_a(new RayTraceContext(vb.func_178788_d(ab), va.func_178787_e(ab), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        return hitAB.func_216346_c() != RayTraceResult.Type.MISS || hitBA.func_216346_c() != RayTraceResult.Type.MISS;
    }

    private void onConnectedPositionsChanged() {
        if (!this.field_145850_b.func_201670_d()) {
            NetworkConnectorConnectionsMessage message = new NetworkConnectorConnectionsMessage(this);
            Network.sendToClientsTrackingTileEntity(message, this);
        }
    }

    private final class NetworkConnectorNetworkInterface
    implements NetworkInterface {
        private NetworkConnectorNetworkInterface() {
        }

        @Override
        public byte[] readEthernetFrame() {
            return null;
        }

        @Override
        public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
            if (timeToLive <= 0) {
                return;
            }
            NetworkConnectorTileEntity.this.localInterface.ifPresent(dst -> {
                if (dst == source) {
                    return;
                }
                dst.writeEthernetFrame(this, frame, timeToLive - 1);
            });
            for (NetworkConnectorTileEntity dst2 : NetworkConnectorTileEntity.this.connectors.values()) {
                if (dst2.func_145837_r() || dst2.networkInterface == source) continue;
                dst2.networkInterface.writeEthernetFrame(this, frame, timeToLive - 1);
            }
        }
    }

    private static final class NullNetworkInterface
    implements NetworkInterface {
        public static final NetworkInterface INSTANCE = new NullNetworkInterface();

        private NullNetworkInterface() {
        }

        @Override
        public byte[] readEthernetFrame() {
            return null;
        }

        @Override
        public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        }
    }

    public static enum ConnectionResult {
        SUCCESS,
        FAILURE,
        FAILURE_FULL,
        FAILURE_TOO_FAR,
        FAILURE_OBSTRUCTED,
        ALREADY_CONNECTED;

    }
}

