/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import javax.annotation.Nullable;
import li.cil.oc2.api.capabilities.NetworkInterface;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.tileentity.AbstractTileEntity;
import li.cil.oc2.common.tileentity.TileEntities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;

public final class NetworkHubTileEntity
extends AbstractTileEntity
implements NetworkInterface {
    private static final int TTL_COST = 1;
    private final NetworkInterface[] adjacentInterfaces = new NetworkInterface[Constants.BLOCK_FACE_COUNT];
    private boolean areAdjacentInterfacesDirty = true;

    public NetworkHubTileEntity() {
        super((TileEntityType)TileEntities.NETWORK_HUB_TILE_ENTITY.get());
    }

    public void handleNeighborChanged() {
        this.areAdjacentInterfacesDirty = true;
    }

    @Override
    public byte[] readEthernetFrame() {
        return null;
    }

    @Override
    public void writeEthernetFrame(NetworkInterface source, byte[] frame, int timeToLive) {
        this.validateAdjacentInterfaces();
        for (NetworkInterface adjacentInterface : this.adjacentInterfaces) {
            if (adjacentInterface == null || adjacentInterface == source) continue;
            adjacentInterface.writeEthernetFrame(this, frame, timeToLive - 1);
        }
    }

    @Override
    protected void collectCapabilities(AbstractTileEntity.CapabilityCollector collector, @Nullable Direction direction) {
        collector.offer(Capabilities.NETWORK_INTERFACE, this);
    }

    private void validateAdjacentInterfaces() {
        if (!this.areAdjacentInterfacesDirty || this.func_145837_r()) {
            return;
        }
        this.areAdjacentInterfacesDirty = false;
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        for (Direction side : Constants.DIRECTIONS) {
            this.adjacentInterfaces[side.func_176745_a()] = null;
            TileEntity neighborTileEntity = this.field_145850_b.func_175625_s(pos.func_177972_a(side));
            if (neighborTileEntity == null) continue;
            LazyOptional capability = neighborTileEntity.getCapability(Capabilities.NETWORK_INTERFACE, side.func_176734_d());
            capability.ifPresent(adjacentInterface -> {
                this.adjacentInterfaces[side.func_176745_a()] = adjacentInterface;
                capability.addListener(unused -> this.handleNeighborChanged());
            });
        }
    }
}

