/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.tileentity;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.DocumentedDevice;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.api.bus.device.object.Parameter;
import li.cil.oc2.api.util.Side;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.tileentity.TileEntities;
import li.cil.oc2.common.util.HorizontalBlockUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public final class RedstoneInterfaceTileEntity
extends TileEntity
implements NamedDevice,
DocumentedDevice {
    private static final String OUTPUT_TAG_NAME = "output";
    private static final String GET_REDSTONE_INPUT = "getRedstoneInput";
    private static final String GET_REDSTONE_OUTPUT = "getRedstoneOutput";
    private static final String SET_REDSTONE_OUTPUT = "setRedstoneOutput";
    private static final String SIDE = "side";
    private static final String VALUE = "value";
    private final byte[] output = new byte[Constants.BLOCK_FACE_COUNT];

    public RedstoneInterfaceTileEntity() {
        super((TileEntityType)TileEntities.REDSTONE_INTERFACE_TILE_ENTITY.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74773_a(OUTPUT_TAG_NAME, this.output);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        byte[] serializedOutput = compound.func_74770_j(OUTPUT_TAG_NAME);
        System.arraycopy(serializedOutput, 0, this.output, 0, Math.min(serializedOutput.length, this.output.length));
    }

    public int getOutputForDirection(Direction direction) {
        Direction localDirection = HorizontalBlockUtils.toLocal(this.func_195044_w(), direction);
        assert (localDirection != null);
        return this.output[localDirection.func_176745_a()];
    }

    @Callback(name="getRedstoneInput")
    public int getRedstoneInput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        if (this.field_145850_b == null) {
            return 0;
        }
        BlockPos pos = this.func_174877_v();
        Direction direction = HorizontalBlockUtils.toGlobal(this.func_195044_w(), side);
        assert (direction != null);
        BlockPos neighborPos = pos.func_177972_a(direction);
        ChunkPos chunkPos = new ChunkPos(neighborPos.func_177958_n(), neighborPos.func_177952_p());
        if (!this.field_145850_b.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            return 0;
        }
        return this.field_145850_b.func_175651_c(neighborPos, direction);
    }

    @Callback(name="getRedstoneOutput", synchronize=false)
    public int getRedstoneOutput(@Parameter(value="side") @Nullable Side side) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        return this.output[side.get3DDataValue()];
    }

    @Callback(name="setRedstoneOutput")
    public void setRedstoneOutput(@Parameter(value="side") @Nullable Side side, @Parameter(value="value") int value) {
        if (side == null) {
            throw new IllegalArgumentException();
        }
        byte clampedValue = (byte)MathHelper.func_76125_a((int)value, (int)0, (int)15);
        if (clampedValue == this.output[side.get3DDataValue()]) {
            return;
        }
        this.output[side.get3DDataValue()] = clampedValue;
        Direction direction = HorizontalBlockUtils.toGlobal(this.func_195044_w(), side);
        if (direction != null) {
            this.notifyNeighbor(direction);
        }
        this.func_70296_d();
    }

    @Override
    public Collection<String> getDeviceTypeNames() {
        return Collections.singletonList("redstone");
    }

    @Override
    public void getDeviceDocumentation(DocumentedDevice.DeviceVisitor visitor) {
        visitor.visitCallback(GET_REDSTONE_INPUT).description("Get the current redstone level received on the specified side. Note that if the current output level on the specified side is not zero, this will affect the measured level.\nSides may be specified by name or zero-based index. Please note thatthe side depends on the orientation of the device.").returnValueDescription("the current received level on the specified side.").parameterDescription(SIDE, "the side to read the input level from.");
        visitor.visitCallback(GET_REDSTONE_OUTPUT).description("Get the current redstone level transmitted on the specified side. This will return the value last set via setRedstoneOutput().\nSides may be specified by name or zero-based index. Please note thatthe side depends on the orientation of the device.").returnValueDescription("the current transmitted level on the specified side.").parameterDescription(SIDE, "the side to read the output level from.");
        visitor.visitCallback(SET_REDSTONE_OUTPUT).description("Set the new redstone level transmitted on the specified side.\nSides may be specified by name or zero-based index. Please note thatthe side depends on the orientation of the device.").parameterDescription(SIDE, "the side to write the output level to.").parameterDescription(VALUE, "the output level to set, will be clamped to [0, 15].");
    }

    private void notifyNeighbor(Direction direction) {
        if (this.field_145850_b == null) {
            return;
        }
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        this.field_145850_b.func_195593_d(this.func_174877_v().func_177972_a(direction), this.func_195044_w().func_177230_c());
    }
}

