/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import li.cil.oc2.common.util.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public final class ItemStackUtils {
    public static CompoundNBT getModDataTag(ItemStack stack) {
        return NBTUtils.getChildTag(stack.func_77978_p(), "oc2");
    }

    public static CompoundNBT getOrCreateModDataTag(ItemStack stack) {
        return NBTUtils.getOrCreateChildTag(stack.func_196082_o(), "oc2");
    }

    @Nullable
    public static BlockState getBlockState(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null || block == Blocks.field_150350_a) {
            return null;
        }
        return block.func_176223_P();
    }

    public static Optional<ItemEntity> spawnAsEntity(World world, BlockPos pos, ItemStack stack) {
        return ItemStackUtils.spawnAsEntity(world, Vector3d.func_237489_a_((Vector3i)pos), stack);
    }

    public static Optional<ItemEntity> spawnAsEntity(World world, Vector3d pos, ItemStack stack) {
        if (world.func_201670_d() || stack.func_190926_b()) {
            return Optional.empty();
        }
        Random rng = world.field_73012_v;
        float tx = 0.5f * (rng.nextFloat() - 1.0f);
        float ty = 0.5f * (rng.nextFloat() - 1.0f);
        float tz = 0.5f * (rng.nextFloat() - 1.0f);
        double px = pos.field_72450_a + (double)tx;
        double py = pos.field_72448_b + (double)ty;
        double pz = pos.field_72449_c + (double)tz;
        ItemEntity entity = new ItemEntity(world, px, py, pz, stack);
        entity.func_174869_p();
        world.func_217376_c((Entity)entity);
        return Optional.of(entity);
    }

    public static Optional<ItemEntity> spawnAsEntity(World world, BlockPos pos, ItemStack stack, @Nullable Direction direction) {
        return ItemStackUtils.spawnAsEntity(world, Vector3d.func_237489_a_((Vector3i)pos), stack, direction);
    }

    public static Optional<ItemEntity> spawnAsEntity(World world, Vector3d pos, ItemStack stack, @Nullable Direction direction) {
        if (direction == null) {
            return ItemStackUtils.spawnAsEntity(world, pos, stack);
        }
        if (world.field_72995_K || stack.func_190926_b()) {
            return Optional.empty();
        }
        Random rng = world.field_73012_v;
        float ox = direction.func_82601_c();
        float oy = direction.func_96559_d();
        float oz = direction.func_82599_e();
        float tx = 0.1f * (rng.nextFloat() - 0.5f) + ox * 0.65f;
        float ty = 0.1f * (rng.nextFloat() - 0.5f) + oy * 0.75f + (ox + oz) * 0.25f;
        float tz = 0.1f * (rng.nextFloat() - 0.5f) + oz * 0.65f;
        double px = pos.field_72450_a + (double)tx;
        double py = pos.field_72448_b + (double)ty;
        double pz = pos.field_72449_c + (double)tz;
        ItemEntity entity = new ItemEntity(world, px, py, pz, stack);
        entity.func_213293_j(0.0125 * (rng.nextDouble() - 0.5) + (double)ox * 0.03, 0.0125 * (rng.nextDouble() - 0.5) + (double)oy * 0.08 + (double)(ox + oz) * 0.03, 0.0125 * (rng.nextDouble() - 0.5) + (double)oz * 0.03);
        entity.func_174869_p();
        world.func_217376_c((Entity)entity);
        return Optional.of(entity);
    }
}

