/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.Optional;
import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.util.Location;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IWorld;

public final class LocationSupplierUtils {
    public static Supplier<Optional<Location>> of(TileEntity tileEntity) {
        return () -> Location.of(tileEntity);
    }

    public static Supplier<Optional<Location>> of(Entity entity) {
        return () -> Location.of(entity);
    }

    public static Supplier<Optional<Location>> of(BlockDeviceQuery query) {
        Optional<Location> location = Optional.of(new Location((IWorld)query.getLevel(), query.getQueryPosition()));
        return () -> location;
    }

    public static Supplier<Optional<Location>> of(ItemDeviceQuery query) {
        Optional<TileEntity> tileEntity = query.getContainerTileEntity();
        if (tileEntity.isPresent()) {
            return () -> Location.of((TileEntity)tileEntity.get());
        }
        Optional<Entity> entity = query.getContainerEntity();
        if (entity.isPresent()) {
            return () -> Location.of((Entity)entity.get());
        }
        return Optional::empty;
    }
}

