/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public final class NBTUtils {
    public static <T extends Enum<T>> void putEnum(CompoundNBT compound, String key, @Nullable Enum<T> value) {
        if (value != null) {
            compound.func_74768_a(key, value.ordinal());
        }
    }

    @Nullable
    public static <T extends Enum<T>> T getEnum(CompoundNBT compound, String key, Class<T> enumType) {
        if (!compound.func_150297_b(key, 3)) {
            return null;
        }
        int ordinal = compound.func_74762_e(key);
        try {
            return (T)((Enum[])enumType.getEnumConstants())[ordinal];
        }
        catch (IndexOutOfBoundsException ignored) {
            return null;
        }
    }

    public static CompoundNBT getChildTag(@Nullable CompoundNBT tag, String ... path) {
        if (tag == null) {
            return new CompoundNBT();
        }
        CompoundNBT childTag = tag;
        for (String tagName : path) {
            if (!childTag.func_150297_b(tagName, 10)) {
                return new CompoundNBT();
            }
            childTag = childTag.func_74775_l(tagName);
        }
        return childTag;
    }

    public static CompoundNBT getOrCreateChildTag(CompoundNBT tag, String ... path) {
        CompoundNBT childTag = tag;
        for (String tagName : path) {
            if (!childTag.func_150297_b(tagName, 10)) {
                childTag.func_218657_a(tagName, (INBT)new CompoundNBT());
            }
            childTag = childTag.func_74775_l(tagName);
        }
        return childTag;
    }

    public static CompoundNBT makeInventoryTag(ItemStack ... items) {
        return new ItemStackHandler(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])items)).serializeNBT();
    }
}

