/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

public final class ServerScheduler {
    private static final TickScheduler globalTickScheduler = new TickScheduler();
    private static final WeakHashMap<IWorld, TickScheduler> worldTickSchedulers = new WeakHashMap();
    private static final WeakHashMap<IWorld, SimpleScheduler> worldUnloadSchedulers = new WeakHashMap();
    private static final WeakHashMap<IWorld, HashMap<ChunkPos, SimpleScheduler>> chunkLoadSchedulers = new WeakHashMap();
    private static final WeakHashMap<IWorld, HashMap<ChunkPos, SimpleScheduler>> chunkUnloadSchedulers = new WeakHashMap();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
    }

    public static void schedule(Runnable runnable) {
        ServerScheduler.schedule(runnable, 0);
    }

    public static void schedule(Runnable runnable, int afterTicks) {
        globalTickScheduler.schedule(runnable, afterTicks);
    }

    public static void schedule(IWorld world, Runnable runnable) {
        ServerScheduler.schedule(world, runnable, 0);
    }

    public static void schedule(IWorld world, Runnable runnable, int afterTicks) {
        TickScheduler scheduler = worldTickSchedulers.computeIfAbsent(world, w -> new TickScheduler());
        scheduler.schedule(runnable, afterTicks);
    }

    public static void scheduleOnUnload(IWorld world, Runnable listener) {
        worldUnloadSchedulers.computeIfAbsent(world, unused -> new SimpleScheduler()).add(listener);
    }

    public static void cancelOnUnload(@Nullable IWorld world, Runnable listener) {
        if (world == null) {
            return;
        }
        SimpleScheduler scheduler = worldUnloadSchedulers.get(world);
        if (scheduler != null) {
            scheduler.remove(listener);
        }
    }

    public static void scheduleOnLoad(IWorld world, ChunkPos chunkPos, Runnable listener) {
        chunkLoadSchedulers.computeIfAbsent(world, unused -> new HashMap()).computeIfAbsent(chunkPos, unused -> new SimpleScheduler()).add(listener);
    }

    public static void cancelOnLoad(@Nullable IWorld world, ChunkPos chunkPos, Runnable listener) {
        if (world == null) {
            return;
        }
        HashMap<ChunkPos, SimpleScheduler> chunkMap = chunkLoadSchedulers.get(world);
        if (chunkMap == null) {
            return;
        }
        SimpleScheduler scheduler = chunkMap.get(chunkPos);
        if (scheduler != null) {
            scheduler.remove(listener);
        }
    }

    public static void scheduleOnUnload(IWorld world, ChunkPos chunkPos, Runnable listener) {
        chunkUnloadSchedulers.computeIfAbsent(world, unused -> new HashMap()).computeIfAbsent(chunkPos, unused -> new SimpleScheduler()).add(listener);
    }

    public static void cancelOnUnload(@Nullable IWorld world, ChunkPos chunkPos, Runnable listener) {
        if (world == null) {
            return;
        }
        HashMap<ChunkPos, SimpleScheduler> chunkMap = chunkUnloadSchedulers.get(world);
        if (chunkMap == null) {
            return;
        }
        SimpleScheduler scheduler = chunkMap.get(chunkPos);
        if (scheduler != null) {
            scheduler.remove(listener);
        }
    }

    private static final class SimpleScheduler {
        private final Set<Runnable> listeners = Collections.newSetFromMap(new WeakHashMap());

        private SimpleScheduler() {
        }

        public void add(Runnable listener) {
            this.listeners.add(listener);
        }

        public void remove(Runnable listener) {
            this.listeners.remove(listener);
        }

        public void run() {
            for (Runnable runnable : this.listeners) {
                runnable.run();
            }
            this.listeners.clear();
        }
    }

    private static final class ScheduledRunnable
    implements Comparable<ScheduledRunnable> {
        public final int tick;
        public final Runnable runnable;

        private ScheduledRunnable(int tick, Runnable runnable) {
            this.tick = tick;
            this.runnable = runnable;
        }

        @Override
        public int compareTo(ScheduledRunnable o) {
            return Integer.compare(this.tick, o.tick);
        }
    }

    private static final class TickScheduler {
        private final PriorityQueue<ScheduledRunnable> queue = new PriorityQueue();
        private int currentTick;

        private TickScheduler() {
        }

        public void schedule(Runnable runnable, int afterTicks) {
            this.queue.add(new ScheduledRunnable(this.currentTick + afterTicks, runnable));
        }

        public void processQueue() {
            while (!this.queue.isEmpty() && this.queue.peek().tick <= this.currentTick) {
                this.queue.poll().runnable.run();
            }
        }

        public void tick() {
            ++this.currentTick;
        }

        public void clear() {
            this.currentTick = 0;
            this.queue.clear();
        }
    }

    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void handleServerStoppedEvent(FMLServerStoppedEvent event) {
            globalTickScheduler.clear();
            worldTickSchedulers.clear();
            worldUnloadSchedulers.clear();
            chunkLoadSchedulers.clear();
            chunkUnloadSchedulers.clear();
        }

        @SubscribeEvent
        public static void handleWorldUnload(WorldEvent.Unload event) {
            IWorld world = event.getWorld();
            worldTickSchedulers.remove(world);
            chunkLoadSchedulers.remove(world);
            chunkUnloadSchedulers.remove(world);
            SimpleScheduler scheduler = (SimpleScheduler)worldUnloadSchedulers.remove(world);
            if (scheduler != null) {
                scheduler.run();
            }
        }

        @SubscribeEvent
        public static void handleChunkLoad(ChunkEvent.Load event) {
            HashMap chunkMap = (HashMap)chunkLoadSchedulers.get(event.getChunk());
            if (chunkMap == null) {
                return;
            }
            SimpleScheduler scheduler = (SimpleScheduler)chunkMap.get(event.getChunk().func_76632_l());
            if (scheduler != null) {
                scheduler.run();
            }
        }

        @SubscribeEvent
        public static void handleChunkUnload(ChunkEvent.Unload event) {
            HashMap chunkMap = (HashMap)chunkUnloadSchedulers.get(event.getChunk());
            if (chunkMap == null) {
                return;
            }
            SimpleScheduler scheduler = (SimpleScheduler)chunkMap.get(event.getChunk().func_76632_l());
            if (scheduler != null) {
                scheduler.run();
            }
        }

        @SubscribeEvent
        public static void handleServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                globalTickScheduler.tick();
                for (TickScheduler scheduler : worldTickSchedulers.values()) {
                    scheduler.tick();
                }
            }
        }

        @SubscribeEvent
        public static void handleWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            globalTickScheduler.processQueue();
            TickScheduler scheduler = (TickScheduler)worldTickSchedulers.get(event.world);
            if (scheduler != null) {
                scheduler.processQueue();
            }
        }
    }
}

