/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import li.cil.oc2.common.util.Location;
import li.cil.oc2.common.util.WorldUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;

public final class ThrottledSoundEmitter {
    private final Supplier<Optional<Location>> location;
    private final SoundEvent sound;
    private long minInterval;
    private SoundCategory category;
    private float volume = 0.95f;
    private float volumeVariance = 0.05f;
    private float pitch = 0.9f;
    private float pitchVariance = 0.1f;
    private long lastEmittedTime;

    public ThrottledSoundEmitter(Supplier<Optional<Location>> location, SoundEvent sound) {
        this.location = location;
        this.sound = sound;
        this.category = SoundCategory.BLOCKS;
        this.minInterval = 500L;
    }

    public void play() {
        long now = System.currentTimeMillis();
        if (now - this.lastEmittedTime > this.minInterval) {
            this.lastEmittedTime = now;
            this.location.get().ifPresent(location -> {
                IWorld world = location.world;
                float volume = this.sampleVolume(world.func_201674_k());
                float pitch = this.samplePitch(world.func_201674_k());
                WorldUtils.playSound(world, location.pos, this.sound, this.category, volume, pitch);
            });
        }
    }

    public ThrottledSoundEmitter withMinInterval(Duration minInterval) {
        this.minInterval = minInterval.toMillis();
        return this;
    }

    public ThrottledSoundEmitter withCategory(SoundCategory category) {
        this.category = category;
        return this;
    }

    public ThrottledSoundEmitter withVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public ThrottledSoundEmitter withVolumeVariance(float volumeVariance) {
        this.volumeVariance = volumeVariance;
        return this;
    }

    public ThrottledSoundEmitter withPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public ThrottledSoundEmitter withPitchVariance(float pitchVariance) {
        this.pitchVariance = pitchVariance;
        return this;
    }

    private float sampleVolume(Random random) {
        return MathHelper.func_76131_a((float)(this.volume + this.volumeVariance * (random.nextFloat() - 0.5f)), (float)0.0f, (float)1.0f);
    }

    private float samplePitch(Random random) {
        return MathHelper.func_76131_a((float)(this.pitch + this.pitchVariance * (random.nextFloat() - 0.5f)), (float)0.0f, (float)1.0f);
    }
}

