/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc2.api.bus.device.DeviceType;
import li.cil.oc2.api.bus.device.provider.ItemDeviceQuery;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.device.util.Devices;
import li.cil.oc2.common.capabilities.Capabilities;
import li.cil.oc2.common.util.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public final class TooltipUtils {
    private static final IFormattableTextComponent DEVICE_NEEDS_REBOOT = new TranslationTextComponent(Constants.TOOLTIP_DEVICE_NEEDS_REBOOT).func_240700_a_(s -> s.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW)));
    private static final ThreadLocal<List<ItemStack>> ITEM_STACKS = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<IntList> ITEM_STACKS_SIZES = ThreadLocal.withInitial(IntArrayList::new);

    public static void tryAddDescription(ItemStack stack, List<ITextComponent> tooltip) {
        ItemDeviceQuery query;
        int energyConsumption;
        ITag tag;
        if (stack.func_190926_b()) {
            return;
        }
        String translationKey = stack.func_77977_a() + ".desc";
        LanguageMap languagemap = LanguageMap.func_74808_a();
        if (languagemap.func_230506_b_(translationKey)) {
            TranslationTextComponent description = new TranslationTextComponent(translationKey);
            tooltip.add((ITextComponent)TooltipUtils.withColor((IFormattableTextComponent)description, TextFormatting.GRAY));
        }
        if ((tag = ItemTags.func_199903_a().func_199910_a(li.cil.oc2.common.tags.ItemTags.DEVICE_NEEDS_REBOOT.func_230234_a_())) != null && tag.func_230235_a_((Object)stack.func_77973_b())) {
            tooltip.add((ITextComponent)DEVICE_NEEDS_REBOOT);
        }
        if ((energyConsumption = Devices.getEnergyConsumption(query = Devices.makeQuery(stack))) > 0) {
            IFormattableTextComponent energy = TooltipUtils.withColor(String.valueOf(energyConsumption), TextFormatting.GREEN);
            tooltip.add((ITextComponent)TooltipUtils.withColor((IFormattableTextComponent)new TranslationTextComponent(Constants.TOOLTIP_ENERGY_CONSUMPTION, new Object[]{energy}), TextFormatting.GRAY));
        }
    }

    public static void addTileEntityInventoryInformation(ItemStack stack, List<ITextComponent> tooltip) {
        TooltipUtils.addInventoryInformation(NBTUtils.getChildTag(stack.func_77978_p(), "BlockEntityTag", "items"), tooltip);
    }

    public static void addEntityInventoryInformation(ItemStack stack, List<ITextComponent> tooltip) {
        TooltipUtils.addInventoryInformation(NBTUtils.getChildTag(stack.func_77978_p(), "oc2", "items"), tooltip);
    }

    public static void addInventoryInformation(CompoundNBT itemsTag, List<ITextComponent> tooltip) {
        TooltipUtils.addInventoryInformation(itemsTag, tooltip, TooltipUtils.getDeviceTypeNames());
    }

    public static void addInventoryInformation(CompoundNBT itemsTag, List<ITextComponent> tooltip, String ... subInventoryNames) {
        List<ItemStack> itemStacks = ITEM_STACKS.get();
        itemStacks.clear();
        IntList itemStackSizes = ITEM_STACKS_SIZES.get();
        itemStackSizes.clear();
        TooltipUtils.collectItemStacks(itemsTag, itemStacks, itemStackSizes);
        for (String subInventoryName : subInventoryNames) {
            if (!itemsTag.func_150297_b(subInventoryName, 10)) continue;
            TooltipUtils.collectItemStacks(itemsTag.func_74775_l(subInventoryName), itemStacks, itemStackSizes);
        }
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack itemStack = itemStacks.get(i);
            tooltip.add((ITextComponent)new StringTextComponent("- ").func_230529_a_(itemStack.func_151000_E()).func_240700_a_(style -> style.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY))).func_230529_a_((ITextComponent)new StringTextComponent(" x").func_240702_b_(String.valueOf(itemStackSizes.getInt(i))).func_240700_a_(style -> style.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GRAY)))));
        }
    }

    public static void addEntityEnergyInformation(ItemStack stack, List<ITextComponent> tooltip) {
        stack.getCapability(Capabilities.ENERGY_STORAGE).ifPresent(energy -> {
            if (energy.getEnergyStored() == 0) {
                return;
            }
            IFormattableTextComponent value = TooltipUtils.withColor(energy.getEnergyStored() + "/" + energy.getMaxEnergyStored(), TextFormatting.GREEN);
            tooltip.add((ITextComponent)TooltipUtils.withColor((IFormattableTextComponent)new TranslationTextComponent(Constants.TOOLTIP_ENERGY, new Object[]{value}), TextFormatting.GRAY));
        });
    }

    public static void addEnergyConsumption(double value, List<ITextComponent> tooltip) {
        if (value > 0.0) {
            tooltip.add((ITextComponent)TooltipUtils.withColor((IFormattableTextComponent)new TranslationTextComponent(Constants.TOOLTIP_ENERGY_CONSUMPTION, new Object[]{TooltipUtils.withColor(new DecimalFormat("#.##").format(value), TextFormatting.GREEN)}), TextFormatting.GRAY));
        }
    }

    public static IFormattableTextComponent withColor(String value, TextFormatting formatting) {
        return TooltipUtils.withColor((IFormattableTextComponent)new StringTextComponent(value), formatting);
    }

    public static IFormattableTextComponent withColor(IFormattableTextComponent text, TextFormatting formatting) {
        return text.func_240700_a_(s -> s.func_240718_a_(Color.func_240744_a_((TextFormatting)formatting)));
    }

    private static String[] getDeviceTypeNames() {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(DeviceType.REGISTRY);
        if (registry != null) {
            return (String[])registry.getValues().stream().map(deviceType -> deviceType.getRegistryName().toString()).toArray(String[]::new);
        }
        return new String[0];
    }

    private static void collectItemStacks(CompoundNBT tag, List<ItemStack> stacks, IntList stackSizes) {
        ListNBT itemsTag = tag.func_150295_c("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundNBT itemTag = itemsTag.func_150305_b(i);
            ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)itemTag);
            boolean didMerge = false;
            for (int j = 0; j < stacks.size(); ++j) {
                ItemStack existingStack = stacks.get(j);
                if (!ItemStack.func_77989_b((ItemStack)existingStack, (ItemStack)itemStack) || !ItemStack.func_77989_b((ItemStack)existingStack, (ItemStack)itemStack)) continue;
                int existingCount = stackSizes.getInt(j);
                stackSizes.set(j, existingCount + itemStack.func_190916_E());
                didMerge = true;
                break;
            }
            if (didMerge) continue;
            stacks.add(itemStack);
            stackSizes.add(itemStack.func_190916_E());
        }
    }
}

