/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;

public final class WorldUtils {
    @Nullable
    public static TileEntity getBlockEntityIfChunkExists(IWorld world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            return null;
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    public static String getBlockName(IWorld world, BlockPos pos) {
        ResourceLocation registryName;
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && (registryName = tileEntity.func_200662_C().getRegistryName()) != null) {
            return registryName.toString();
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        ResourceLocation registryName2 = block.getRegistryName();
        if (registryName2 != null) {
            return registryName2.toString();
        }
        if (tileEntity != null) {
            return tileEntity.getClass().getSimpleName();
        }
        return block.getClass().getSimpleName();
    }

    public static void playSound(IWorld world, BlockPos pos, SoundType soundType, Function<SoundType, SoundEvent> soundEvent) {
        WorldUtils.playSound(world, pos, soundType, soundEvent.apply(soundType));
    }

    public static void playSound(IWorld world, BlockPos pos, SoundType soundType, SoundEvent soundEvent) {
        WorldUtils.playSound(world, pos, soundEvent, SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
    }

    public static void playSound(IWorld world, BlockPos pos, SoundEvent soundEvent, SoundCategory soundCategory, float volume, float pitch) {
        world.func_184133_a(null, pos, soundEvent, soundCategory, volume, pitch);
    }
}

