/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.device.vm.FirmwareLoader;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.api.bus.device.vm.event.VMPausingEvent;
import li.cil.oc2.common.Constants;
import li.cil.oc2.common.bus.CommonDeviceBusController;
import li.cil.oc2.common.bus.RPCDeviceBusAdapter;
import li.cil.oc2.common.serialization.NBTSerialization;
import li.cil.oc2.common.util.NBTUtils;
import li.cil.oc2.common.vm.AbstractTerminalVMRunner;
import li.cil.oc2.common.vm.BuiltinDevices;
import li.cil.oc2.common.vm.VMDeviceBusAdapter;
import li.cil.oc2.common.vm.VMRunState;
import li.cil.oc2.common.vm.VirtualMachine;
import li.cil.oc2.common.vm.context.global.GlobalVMContext;
import li.cil.sedna.api.Board;
import li.cil.sedna.api.device.MemoryMappedDevice;
import li.cil.sedna.api.device.serial.SerialDevice;
import li.cil.sedna.api.memory.MemoryAccessException;
import li.cil.sedna.riscv.R5Board;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractVirtualMachine
implements VirtualMachine {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String STATE_TAG_NAME = "state";
    private static final String RUNNER_TAG_NAME = "runner";
    public static final String BUS_STATE_TAG_NAME = "busState";
    public static final String RUN_STATE_TAG_NAME = "runState";
    public static final String BOOT_ERROR_TAG_NAME = "bootError";
    private static final int DEVICE_LOAD_RETRY_INTERVAL = 200;
    public final CommonDeviceBusController busController;
    private CommonDeviceBusController.BusState busState = CommonDeviceBusController.BusState.SCAN_PENDING;
    private int loadDevicesDelay;
    public SerializedState state = new SerializedState();
    public AbstractTerminalVMRunner runner;
    private VMRunState runState = VMRunState.STOPPED;
    private ITextComponent bootError;

    public AbstractVirtualMachine(CommonDeviceBusController busController) {
        this.busController = busController;
        busController.onBeforeScan.add(this::handleBeforeScan);
        busController.onAfterDeviceScan.add(this::handleAfterDeviceScan);
        busController.onDevicesAdded.add(this::handleDevicesAdded);
        busController.onDevicesRemoved.add(this::handleDevicesRemoved);
        this.state.board = new R5Board();
        this.state.context = new GlobalVMContext((Board)this.state.board, this::joinWorkerThread);
        this.state.builtinDevices = new BuiltinDevices(this.state.context);
        this.state.rpcAdapter = new RPCDeviceBusAdapter((SerialDevice)this.state.builtinDevices.rpcSerialDevice);
        this.state.vmAdapter = new VMDeviceBusAdapter(this.state.context);
        this.state.board.getCpu().setFrequency(25000000);
        this.state.board.setBootArguments("root=/dev/vda rw");
        this.state.board.setStandardOutputDevice((MemoryMappedDevice)this.state.builtinDevices.uart);
    }

    public void suspend() {
        this.joinWorkerThread();
        this.state.vmAdapter.suspend();
        this.state.rpcAdapter.suspend();
        this.state.context.invalidate();
        this.busController.dispose();
    }

    @Override
    public boolean isRunning() {
        return this.getBusState() == CommonDeviceBusController.BusState.READY && this.getRunState() == VMRunState.RUNNING;
    }

    @Override
    public CommonDeviceBusController.BusState getBusState() {
        return this.busState;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setBusStateClient(CommonDeviceBusController.BusState value) {
        this.busState = value;
    }

    @Override
    public VMRunState getRunState() {
        return this.runState;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRunStateClient(VMRunState value) {
        this.runState = value;
    }

    @Override
    @Nullable
    public ITextComponent getBootError() {
        switch (this.busState) {
            case SCAN_PENDING: 
            case INCOMPLETE: {
                return new TranslationTextComponent(Constants.COMPUTER_BUS_STATE_INCOMPLETE);
            }
            case TOO_COMPLEX: {
                return new TranslationTextComponent(Constants.COMPUTER_BUS_STATE_TOO_COMPLEX);
            }
            case MULTIPLE_CONTROLLERS: {
                return new TranslationTextComponent(Constants.COMPUTER_BUS_STATE_MULTIPLE_CONTROLLERS);
            }
            case READY: {
                switch (this.runState) {
                    case STOPPED: 
                    case LOADING_DEVICES: {
                        return this.bootError;
                    }
                }
            }
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setBootErrorClient(ITextComponent value) {
        this.bootError = value;
    }

    @Override
    public void start() {
        if (this.runState == VMRunState.RUNNING) {
            return;
        }
        this.setBootError(null);
        this.setRunState(VMRunState.LOADING_DEVICES);
        this.loadDevicesDelay = 0;
    }

    @Override
    public void stop() {
        switch (this.runState) {
            case LOADING_DEVICES: {
                this.setRunState(VMRunState.STOPPED);
                break;
            }
            case RUNNING: {
                this.stopRunnerAndReset();
            }
        }
    }

    private void joinWorkerThread() {
        if (this.runner != null) {
            try {
                this.state.context.postEvent(new VMPausingEvent());
                this.runner.join();
                this.runner.scheduleResumeEvent();
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
                this.runner = null;
            }
        }
    }

    public void pauseAndReload() {
        this.state.rpcAdapter.pause();
        if (this.runState == VMRunState.RUNNING) {
            this.runState = VMRunState.LOADING_DEVICES;
        }
    }

    public void resume(boolean didDevicesChange) {
        this.state.rpcAdapter.resume(this.busController, didDevicesChange);
    }

    protected void stopRunnerAndReset() {
        this.joinWorkerThread();
        this.setRunState(VMRunState.STOPPED);
        this.state.board.reset();
        this.state.rpcAdapter.reset();
        this.state.vmAdapter.unmount();
        this.runner = null;
    }

    public void tick() {
        this.busController.scan();
        this.setBusState(this.busController.getState());
        if (this.busState != CommonDeviceBusController.BusState.READY) {
            return;
        }
        if (this.state.board.isRestarting()) {
            this.stop();
            this.start();
        }
        switch (this.runState) {
            case LOADING_DEVICES: {
                this.load();
                break;
            }
            case RUNNING: {
                this.run();
            }
        }
    }

    public CompoundNBT serialize() {
        this.joinWorkerThread();
        CompoundNBT tag = new CompoundNBT();
        if (this.runner != null) {
            tag.func_218657_a(RUNNER_TAG_NAME, (INBT)NBTSerialization.serialize(this.runner));
        } else {
            NBTUtils.putEnum(tag, RUN_STATE_TAG_NAME, this.runState);
        }
        tag.func_218657_a(STATE_TAG_NAME, (INBT)NBTSerialization.serialize(this.state));
        return tag;
    }

    public void deserialize(CompoundNBT tag) {
        this.joinWorkerThread();
        if (tag.func_150297_b(RUNNER_TAG_NAME, 10)) {
            this.runner = this.createRunner();
            NBTSerialization.deserialize(tag.func_74775_l(RUNNER_TAG_NAME), this.runner);
            this.runState = VMRunState.LOADING_DEVICES;
        } else {
            this.runState = NBTUtils.getEnum(tag, RUN_STATE_TAG_NAME, VMRunState.class);
            if (this.runState == null) {
                this.runState = VMRunState.STOPPED;
            } else if (this.runState == VMRunState.RUNNING) {
                this.runState = VMRunState.LOADING_DEVICES;
            }
        }
        if (tag.func_150297_b(STATE_TAG_NAME, 10)) {
            NBTSerialization.deserialize(tag.func_74775_l(STATE_TAG_NAME), this.state);
        }
    }

    protected abstract AbstractTerminalVMRunner createRunner();

    protected abstract boolean consumeEnergy(int var1, boolean var2);

    protected void handleBusStateChanged(CommonDeviceBusController.BusState value) {
    }

    protected void handleRunStateChanged(VMRunState value) {
    }

    protected void handleBootErrorChanged(@Nullable ITextComponent value) {
    }

    protected void error(@Nullable ITextComponent message) {
        this.error(message, true);
    }

    protected void error(@Nullable ITextComponent message, boolean reset) {
        if (reset) {
            this.stopRunnerAndReset();
        }
        this.setBootError(message);
    }

    private void load() {
        if (this.loadDevicesDelay > 0) {
            --this.loadDevicesDelay;
            return;
        }
        if (!this.consumeEnergy(this.busController.getEnergyConsumption(), true)) {
            this.error((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_NOT_ENOUGH_ENERGY));
            return;
        }
        VMDeviceLoadResult loadResult = this.state.vmAdapter.mount();
        if (!loadResult.wasSuccessful()) {
            if (loadResult.getErrorMessage() != null) {
                this.error(loadResult.getErrorMessage(), false);
            } else {
                this.error((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_UNKNOWN), false);
            }
            this.loadDevicesDelay = 200;
            return;
        }
        if (this.busController.getDevices().stream().noneMatch(device -> device instanceof FirmwareLoader)) {
            this.error((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_MISSING_FIRMWARE));
            return;
        }
        if (this.runner == null) {
            try {
                this.state.board.reset();
                this.state.board.initialize();
                this.state.board.setRunning(true);
            }
            catch (IllegalStateException e) {
                this.error((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_INSUFFICIENT_MEMORY));
                return;
            }
            catch (MemoryAccessException e) {
                LOGGER.error((Object)e);
                this.error((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_UNKNOWN));
                return;
            }
            this.runner = this.createRunner();
        }
        this.setRunState(VMRunState.RUNNING);
    }

    private void run() {
        ITextComponent runtimeError = this.runner.getRuntimeError();
        if (runtimeError != null) {
            this.error(runtimeError);
            return;
        }
        if (!this.state.board.isRunning()) {
            this.stopRunnerAndReset();
            return;
        }
        if (!this.consumeEnergy(this.busController.getEnergyConsumption(), false)) {
            this.error((ITextComponent)new TranslationTextComponent(Constants.COMPUTER_ERROR_NOT_ENOUGH_ENERGY));
            return;
        }
        this.runner.tick();
    }

    private void setBusState(CommonDeviceBusController.BusState value) {
        if (value == this.busState) {
            return;
        }
        this.busState = value;
        this.handleBusStateChanged(this.busState);
    }

    private void setRunState(VMRunState value) {
        if (value == this.runState) {
            return;
        }
        this.runState = value;
        this.handleRunStateChanged(value);
    }

    private void setBootError(@Nullable ITextComponent value) {
        if (Objects.equals(value, this.bootError)) {
            return;
        }
        this.bootError = value;
        this.handleBootErrorChanged(value);
    }

    private void handleBeforeScan() {
        this.pauseAndReload();
    }

    private void handleAfterDeviceScan(CommonDeviceBusController.AfterDeviceScanEvent event) {
        this.resume(event.didDevicesChange);
    }

    private void handleDevicesAdded(CommonDeviceBusController.DevicesChangedEvent event) {
        this.state.vmAdapter.addDevices(event.devices);
    }

    private void handleDevicesRemoved(CommonDeviceBusController.DevicesChangedEvent event) {
        this.state.vmAdapter.removeDevices(event.devices);
    }

    @Serialized
    public static final class SerializedState {
        public R5Board board;
        public GlobalVMContext context;
        public BuiltinDevices builtinDevices;
        public RPCDeviceBusAdapter rpcAdapter;
        public VMDeviceBusAdapter vmAdapter;
    }
}

