/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Collectors;
import li.cil.oc2.common.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Allocator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final HashMap<UUID, Allocation> ALLOCATIONS = new HashMap();
    private static long allocated;

    public static UUID createHandle() {
        return UUID.randomUUID();
    }

    public static boolean claimMemory(UUID handle, int size) {
        if (!Allocator.checkArgs(handle, size)) {
            return false;
        }
        if (size != 0) {
            ALLOCATIONS.put(handle, new Allocation(size));
            allocated += (long)size;
        }
        return true;
    }

    public static void freeMemory(UUID handle) {
        Allocation allocation = ALLOCATIONS.remove(handle);
        if (allocation != null) {
            allocated -= (long)allocation.size;
        }
    }

    public static void resetAndCheckLeaks() {
        if (allocated > 0L) {
            for (Allocation allocation : ALLOCATIONS.values()) {
                LOGGER.error(Arrays.stream(allocation.stacktrace).skip(3L).map(StackTraceElement::toString).collect(Collectors.joining("\n  ", "Leaked memory allocation:\n  ", "")));
            }
        }
        ALLOCATIONS.clear();
        allocated = 0L;
    }

    private static boolean checkArgs(UUID handle, int size) {
        if (ALLOCATIONS.containsKey(handle)) {
            throw new IllegalStateException("Handle is already in use. It must be freed before it can be reused.");
        }
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return Config.maxAllocatedMemory - (long)size >= allocated;
    }

    private static final class Allocation {
        public final int size;
        private final StackTraceElement[] stacktrace;

        private Allocation(int size) {
            this.size = size;
            this.stacktrace = new Throwable().getStackTrace();
        }
    }
}

