/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.bytes.ByteArrayFIFOQueue;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import li.cil.ceres.api.Serialized;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Serialized
public final class Terminal {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 24;
    public static final int CHAR_WIDTH = 8;
    public static final int CHAR_HEIGHT = 16;
    private static final int TAB_WIDTH = 4;
    private static final int COLOR_BLACK = 0;
    private static final int COLOR_RED = 1;
    private static final int COLOR_GREEN = 2;
    private static final int COLOR_YELLOW = 3;
    private static final int COLOR_BLUE = 4;
    private static final int COLOR_MAGENTA = 5;
    private static final int COLOR_CYAN = 6;
    private static final int COLOR_WHITE = 7;
    private static final int COLOR_MASK = 7;
    private static final int COLOR_FOREGROUND_SHIFT = 3;
    private static final int STYLE_BOLD_MASK = 1;
    private static final int STYLE_DIM_MASK = 2;
    private static final int STYLE_UNDERLINE_MASK = 4;
    private static final int STYLE_BLINK_MASK = 8;
    private static final int STYLE_INVERT_MASK = 16;
    private static final int STYLE_HIDDEN_MASK = 32;
    private static final byte DEFAULT_COLORS = 56;
    private static final byte DEFAULT_STYLE = 0;
    private final ByteArrayFIFOQueue input = new ByteArrayFIFOQueue(32);
    private final byte[] buffer = new byte[1920];
    private final byte[] colors = new byte[1920];
    private final byte[] styles = new byte[1920];
    private State state = State.NORMAL;
    private final int[] args = new int[4];
    private int argCount = 0;
    private int x;
    private int y;
    private int savedX;
    private int savedY;
    private byte color = (byte)56;
    private byte style = 0;
    private final transient AtomicInteger dirty = new AtomicInteger(-1);
    private transient Object renderer;
    private transient boolean displayOnly;
    private transient boolean hasPendingBell;

    public Terminal() {
        this.clear();
    }

    public void setDisplayOnly(boolean value) {
        this.displayOnly = value;
    }

    public int getWidth() {
        return 640;
    }

    public int getHeight() {
        return 384;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack stack) {
        if (this.hasPendingBell) {
            this.hasPendingBell = false;
            Minecraft client = Minecraft.func_71410_x();
            client.execute(() -> client.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)NoteBlockInstrument.PLING.func_208088_a(), (float)1.0f)));
        }
        if (this.renderer == null) {
            this.renderer = new Renderer(this);
        }
        ((Renderer)this.renderer).render(this.dirty, stack);
    }

    public synchronized int readInput() {
        if (this.input.isEmpty()) {
            return -1;
        }
        return this.input.dequeueByte() & 0xFF;
    }

    @Nullable
    public synchronized ByteBuffer getInput() {
        if (this.input.isEmpty()) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.input.size());
        while (!this.input.isEmpty()) {
            buffer.put(this.input.dequeueByte());
        }
        buffer.flip();
        return buffer;
    }

    public synchronized void putInput(ByteBuffer values) {
        while (values.hasRemaining()) {
            this.input.enqueue(values.get());
        }
    }

    public synchronized void putOutput(ByteBuffer values) {
        while (values.hasRemaining()) {
            this.putOutput(values.get());
        }
    }

    public synchronized void putInput(byte value) {
        this.input.enqueue(value);
    }

    public void putOutput(byte value) {
        block52: {
            char ch = (char)value;
            block0 : switch (this.state) {
                case NORMAL: {
                    switch (value) {
                        case 13: {
                            this.setCursorPos(0, this.y);
                            break block0;
                        }
                        case 10: {
                            this.putNewLine();
                            break block0;
                        }
                        case 9: {
                            if (this.x + 4 > 80) {
                                this.setCursorPos(0, this.y);
                                this.putNewLine();
                                break block0;
                            }
                            this.setCursorPos(this.x + 4 - this.x % 4, this.y);
                            break block0;
                        }
                        case 8: {
                            this.setCursorPos(this.x - 1, this.y);
                            break block0;
                        }
                        case 7: {
                            this.hasPendingBell = true;
                            break block0;
                        }
                        case 27: {
                            this.state = State.ESCAPE;
                            break block0;
                        }
                    }
                    if (Character.isISOControl(ch)) break;
                    this.putChar(ch);
                    break;
                }
                case ESCAPE: {
                    if (ch == '[') {
                        Arrays.fill(this.args, 0);
                        this.argCount = 0;
                        this.state = State.SEQUENCE;
                        break;
                    }
                    this.state = State.NORMAL;
                    break;
                }
                case SEQUENCE: {
                    if (ch >= '0' && ch <= '9') {
                        if (this.argCount >= this.args.length) break;
                        int digit = ch - 48;
                        if (this.args[this.argCount] < (Integer.MAX_VALUE - digit) / 10) {
                            this.args[this.argCount] = this.args[this.argCount] * 10 + digit;
                            break;
                        }
                        this.args[this.argCount] = Integer.MAX_VALUE;
                        break;
                    }
                    if (this.argCount < this.args.length) {
                        ++this.argCount;
                    }
                    if (ch == ';' || ch == '?') break;
                    this.state = State.NORMAL;
                    switch (ch) {
                        case 'A': {
                            this.setCursorPos(this.x, this.y - Math.max(1, this.args[0]));
                            break block0;
                        }
                        case 'B': {
                            this.setCursorPos(this.x, this.y + Math.max(1, this.args[0]));
                            break block0;
                        }
                        case 'C': {
                            this.setCursorPos(this.x + Math.max(1, this.args[0]), this.y);
                            break block0;
                        }
                        case 'D': {
                            this.setCursorPos(this.x - Math.max(1, this.args[0]), this.y);
                            break block0;
                        }
                        case 'E': {
                            this.setCursorPos(0, this.y + Math.min(1, this.args[0]));
                            break block0;
                        }
                        case 'F': {
                            this.setCursorPos(0, this.y - Math.min(1, this.args[0]));
                            break block0;
                        }
                        case 'G': {
                            this.setCursorPos(this.args[0] - 1, this.y);
                            break block0;
                        }
                        case 'H': 
                        case 'f': {
                            this.setCursorPos(this.args[1] - 1, this.args[0] - 1);
                            break block0;
                        }
                        case 'J': {
                            if (this.args[0] == 0) {
                                this.clearLine(this.y, this.x, 80);
                                for (int iy = this.y + 1; iy < 24; ++iy) {
                                    this.clearLine(iy);
                                }
                            } else if (this.args[0] == 1) {
                                this.clearLine(this.y, 0, this.x + 1);
                                for (int iy = 0; iy < this.y; ++iy) {
                                    this.clearLine(iy);
                                }
                            } else if (this.args[0] == 2) {
                                this.clear();
                            }
                            break block52;
                        }
                        case 'K': {
                            if (this.args[0] == 0) {
                                this.clearLine(this.y, this.x, 80);
                                break block0;
                            }
                            if (this.args[0] == 1) {
                                this.clearLine(this.y, 0, this.x + 1);
                                break block0;
                            }
                            if (this.args[0] == 2) {
                                this.clearLine(this.y);
                                break block0;
                            }
                            break block52;
                        }
                        case 'm': {
                            for (int i = 0; i < this.argCount; ++i) {
                                int arg = this.args[i];
                                this.selectStyle(arg);
                            }
                            break block52;
                        }
                        case 'n': {
                            switch (this.args[0]) {
                                case 5: {
                                    if (this.displayOnly) break block52;
                                    this.putInput((byte)27);
                                    for (char i : "[0n".toCharArray()) {
                                        this.putInput((byte)i);
                                    }
                                    break block52;
                                }
                                case 6: {
                                    if (!this.displayOnly) {
                                        this.putInput((byte)27);
                                        for (char i : String.format("[%d;%dR", this.y % 24 + 1, this.x + 1).toCharArray()) {
                                            this.putInput((byte)i);
                                        }
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block52;
                        }
                        case 's': {
                            this.savedX = this.x;
                            this.savedY = this.y;
                            break block0;
                        }
                        case 'u': {
                            this.x = this.savedX;
                            this.y = this.savedY;
                        }
                    }
                }
            }
        }
    }

    private void selectStyle(int sgr) {
        switch (sgr) {
            case 0: {
                this.color = (byte)56;
                this.style = 0;
                break;
            }
            case 1: {
                this.style = (byte)(this.style | 1);
                break;
            }
            case 2: {
                this.style = (byte)(this.style | 2);
                break;
            }
            case 4: {
                this.style = (byte)(this.style | 4);
                break;
            }
            case 5: {
                this.style = (byte)(this.style | 8);
                break;
            }
            case 7: {
                this.style = (byte)(this.style | 0x10);
                break;
            }
            case 8: {
                this.style = (byte)(this.style | 0x20);
                break;
            }
            case 22: {
                this.style = (byte)(this.style & 0xFFFFFFFC);
                break;
            }
            case 24: {
                this.style = (byte)(this.style & 0xFFFFFFFB);
                break;
            }
            case 25: {
                this.style = (byte)(this.style & 0xFFFFFFF7);
                break;
            }
            case 27: {
                this.style = (byte)(this.style & 0xFFFFFFEF);
                break;
            }
            case 28: {
                this.style = (byte)(this.style & 0xFFFFFFDF);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                int color = sgr - 30;
                this.color = (byte)(this.color & 0xFFFFFFC7 | color << 3);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                int color = sgr - 40;
                this.color = (byte)(this.color & 0xFFFFFFF8 | color);
                break;
            }
        }
    }

    private void setCursorPos(int x, int y) {
        this.x = Math.max(0, Math.min(79, x));
        this.y = Math.max(0, Math.min(23, y));
    }

    private void putChar(char ch) {
        if (this.x >= 80) {
            this.setCursorPos(0, this.y);
            this.putNewLine();
        }
        this.setChar(this.x, this.y, ch);
        ++this.x;
    }

    private void setChar(int x, int y, char ch) {
        int index = x + y * 80;
        if (this.buffer[index] == ch && this.colors[index] == this.color && this.styles[index] == this.style) {
            return;
        }
        this.buffer[index] = (byte)ch;
        this.colors[index] = this.color;
        this.styles[index] = this.style;
        this.dirty.accumulateAndGet(1 << y, (prev, next) -> prev | next);
    }

    private void clear() {
        Arrays.fill(this.buffer, (byte)32);
        Arrays.fill(this.colors, (byte)56);
        Arrays.fill(this.styles, (byte)0);
        this.dirty.set(0xFFFFFF);
    }

    private void clearLine(int y) {
        this.clearLine(y, 0, 80);
    }

    private void clearLine(int y, int fromIndex, int toIndex) {
        Arrays.fill(this.buffer, y * 80 + fromIndex, y * 80 + toIndex, (byte)32);
        Arrays.fill(this.colors, y * 80 + fromIndex, y * 80 + toIndex, (byte)56);
        Arrays.fill(this.styles, y * 80 + fromIndex, y * 80 + toIndex, (byte)0);
        this.dirty.accumulateAndGet(1 << y, (prev, next) -> prev | next);
    }

    private void putNewLine() {
        ++this.y;
        if (this.y >= 24) {
            this.y = 23;
            this.shiftUpOne();
        }
    }

    private void shiftUpOne() {
        System.arraycopy(this.buffer, 80, this.buffer, 0, this.buffer.length - 80);
        System.arraycopy(this.colors, 80, this.colors, 0, this.colors.length - 80);
        System.arraycopy(this.styles, 80, this.styles, 0, this.styles.length - 80);
        Arrays.fill(this.buffer, 1840, 1920, (byte)32);
        Arrays.fill(this.colors, 1840, 1920, (byte)56);
        Arrays.fill(this.styles, 1840, 1920, (byte)0);
        this.dirty.set(-1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Renderer {
        private static final ResourceLocation LOCATION_FONT_TEXTURE = new ResourceLocation("oc2", "textures/font/terminus.png");
        private static final int TEXTURE_RESOLUTION = 256;
        private static final float ONE_OVER_TEXTURE_RESOLUTION = 0.00390625f;
        private static final int TEXTURE_COLUMNS = 16;
        private static final int TEXTURE_BOLD_SHIFT = 16;
        private static final int[] COLORS = new int[]{65793, 0xEE3322, 0x33DD44, 0xFFCC11, 0x1188EE, 0xDD33CC, 0x22CCDD, 0xEEEEEE};
        private static final int[] DIM_COLORS = new int[]{65793, 0x772211, 0x116622, 0x886611, 0x115588, 0x771177, 0x116677, 0x777777};
        private final Terminal terminal;
        private final Object[] lines = new Object[24];
        private Object lastMatrix;

        public Renderer(Terminal terminal) {
            this.terminal = terminal;
        }

        public void render(AtomicInteger dirty, MatrixStack stack) {
            this.validateLineCache(dirty, stack);
            this.renderBuffer();
            if ((System.currentTimeMillis() + (long)this.terminal.hashCode()) % 1000L > 500L) {
                this.renderCursor(stack);
            }
        }

        private void renderBuffer() {
            RenderSystem.depthMask((boolean)false);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(LOCATION_FONT_TEXTURE);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            for (Object line : this.lines) {
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_178993_a((BufferBuilder.State)line);
                buffer.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
            }
            RenderSystem.depthMask((boolean)true);
        }

        private void validateLineCache(AtomicInteger dirty, MatrixStack stack) {
            if (!Objects.equals(this.lastMatrix, stack.func_227866_c_().func_227870_a_())) {
                this.lastMatrix = stack.func_227866_c_().func_227870_a_();
                dirty.set(-1);
            }
            if (dirty.get() == 0) {
                return;
            }
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            int mask = dirty.getAndSet(0);
            for (int row = 0; row < this.lines.length; ++row) {
                if ((mask & 1 << row) == 0) continue;
                stack.func_227860_a_();
                stack.func_227861_a_(0.0, (double)(row * 16), 0.0);
                Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                this.renderBackground(matrix, buffer, row);
                this.renderForeground(matrix, buffer, row);
                this.lines[row] = buffer.func_181672_a();
                buffer.func_178977_d();
                buffer.func_227833_h_();
                stack.func_227865_b_();
            }
        }

        private void renderBackground(Matrix4f matrix, BufferBuilder buffer, int row) {
            float backgroundStartX = -1.0f;
            int backgroundColor = 0;
            float tx = 0.0f;
            int col = 0;
            int index = row * 80;
            while (col < 80) {
                byte colors = this.terminal.colors[index];
                byte style = this.terminal.styles[index];
                if ((style & 0x20) == 0) {
                    boolean hasBackground;
                    int[] palette = (style & 2) != 0 ? DIM_COLORS : COLORS;
                    int foregroundIndex = colors >> 3 & 7;
                    int backgroundIndex = colors & 7;
                    int background = palette[(style & 0x10) == 0 ? backgroundIndex : foregroundIndex];
                    boolean hadBackground = backgroundStartX >= 0.0f;
                    boolean bl = hasBackground = background != palette[0];
                    if (!hadBackground && hasBackground) {
                        backgroundStartX = tx;
                        backgroundColor = background;
                    } else if (hadBackground && (!hasBackground || backgroundColor != background)) {
                        this.renderBackground(matrix, buffer, backgroundStartX, tx, backgroundColor);
                        if (hasBackground) {
                            backgroundStartX = tx;
                            backgroundColor = background;
                        } else {
                            backgroundStartX = -1.0f;
                        }
                    }
                    tx += 8.0f;
                }
                ++col;
                ++index;
            }
            if (backgroundStartX >= 0.0f) {
                this.renderBackground(matrix, buffer, backgroundStartX, tx, backgroundColor);
            }
        }

        private void renderBackground(Matrix4f matrix, BufferBuilder buffer, float x0, float x1, int color) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float ulu = 0.99609375f;
            float ulv = 0.00390625f;
            buffer.func_227888_a_(matrix, x0, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
            buffer.func_227888_a_(matrix, x1, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
            buffer.func_227888_a_(matrix, x1, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
            buffer.func_227888_a_(matrix, x0, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
        }

        private void renderForeground(Matrix4f matrix, BufferBuilder buffer, int row) {
            float tx = 0.0f;
            int col = 0;
            int index = row * 80;
            while (col < 80) {
                byte colors = this.terminal.colors[index];
                byte style = this.terminal.styles[index];
                if ((style & 0x20) == 0) {
                    int[] palette = (style & 2) != 0 ? DIM_COLORS : COLORS;
                    int foregroundIndex = colors >> 3 & 7;
                    int backgroundIndex = colors & 7;
                    int foreground = palette[(style & 0x10) == 0 ? foregroundIndex : backgroundIndex];
                    int character = this.terminal.buffer[index] & 0xFF;
                    this.renderForeground(matrix, buffer, tx, character, foreground, style);
                    tx += 8.0f;
                }
                ++col;
                ++index;
            }
        }

        private void renderForeground(Matrix4f matrix, BufferBuilder buffer, float offset, int character, int color, byte style) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            if (Renderer.isPrintableCharacter((char)character)) {
                int x = character % 16 + ((style & 1) != 0 ? 16 : 0);
                int y = character / 16;
                float u0 = (float)x * 0.03125f;
                float u1 = (float)(x + 1) * 0.03125f;
                float v0 = (float)y * 0.0625f;
                float v1 = (float)(y + 1) * 0.0625f;
                buffer.func_227888_a_(matrix, offset, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u0, v1).func_181675_d();
                buffer.func_227888_a_(matrix, offset + 8.0f, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u1, v1).func_181675_d();
                buffer.func_227888_a_(matrix, offset + 8.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u1, v0).func_181675_d();
                buffer.func_227888_a_(matrix, offset, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u0, v0).func_181675_d();
            }
            if ((style & 4) != 0) {
                float ulu = 0.99609375f;
                float ulv = 0.00390625f;
                buffer.func_227888_a_(matrix, offset, 13.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
                buffer.func_227888_a_(matrix, offset + 8.0f, 13.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
                buffer.func_227888_a_(matrix, offset + 8.0f, 14.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
                buffer.func_227888_a_(matrix, offset, 14.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(0.99609375f, 0.00390625f).func_181675_d();
            }
        }

        private void renderCursor(MatrixStack stack) {
            if (this.terminal.x < 0 || this.terminal.x >= 80 || this.terminal.y < 0 || this.terminal.y >= 24) {
                return;
            }
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableTexture();
            stack.func_227860_a_();
            stack.func_227861_a_((double)(this.terminal.x * 8), (double)(this.terminal.y * 16), 0.0);
            Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int foreground = COLORS[7];
            float r = (float)(foreground >> 16 & 0xFF) / 255.0f;
            float g = (float)(foreground >> 8 & 0xFF) / 255.0f;
            float b = (float)(foreground & 0xFF) / 255.0f;
            buffer.func_227888_a_(matrix, 0.0f, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, 8.0f, 16.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, 8.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            buffer.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
            stack.func_227865_b_();
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
        }

        private static boolean isPrintableCharacter(char ch) {
            return ch == '\u0000' || ch > ' ' && ch <= '~' || ch >= '\u00b1';
        }
    }

    public static enum State {
        NORMAL,
        ESCAPE,
        SEQUENCE;

    }
}

