/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.OptionalLong;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.vm.VMDevice;
import li.cil.oc2.api.bus.device.vm.VMDeviceLoadResult;
import li.cil.oc2.common.vm.BaseAddressProvider;
import li.cil.oc2.common.vm.context.global.GlobalVMContext;
import li.cil.oc2.common.vm.context.managed.ManagedVMContext;

public final class VMDeviceBusAdapter {
    private final HashMap<VMDevice, ManagedVMContext> deviceContexts = new HashMap();
    private final ArrayList<VMDevice> incompleteLoads = new ArrayList();
    private BaseAddressProvider baseAddressProvider = unused -> OptionalLong.empty();
    @Serialized
    private GlobalVMContext globalContext;

    public VMDeviceBusAdapter(GlobalVMContext context) {
        this.globalContext = context;
    }

    public void setBaseAddressProvider(BaseAddressProvider provider) {
        this.baseAddressProvider = provider;
    }

    public VMDeviceLoadResult mount() {
        for (int i = 0; i < this.incompleteLoads.size(); ++i) {
            VMDevice device = this.incompleteLoads.get(i);
            ManagedVMContext context = new ManagedVMContext(this.globalContext, this.globalContext, () -> this.baseAddressProvider.getBaseAddress(device));
            this.deviceContexts.put(device, context);
            VMDeviceLoadResult result = device.mount(context);
            context.freeze();
            if (result.wasSuccessful()) continue;
            while (i >= 0) {
                this.deviceContexts.get(this.incompleteLoads.get(i)).invalidate();
                --i;
            }
            return result;
        }
        this.incompleteLoads.clear();
        this.globalContext.updateReservations();
        return VMDeviceLoadResult.success();
    }

    public void unmount() {
        for (VMDevice device : this.deviceContexts.keySet()) {
            device.unmount();
        }
        this.unload();
    }

    public void suspend() {
        for (VMDevice device : this.deviceContexts.keySet()) {
            device.suspend();
        }
        this.unload();
    }

    public void addDevices(Collection<Device> devices) {
        for (Device device : devices) {
            if (!(device instanceof VMDevice)) continue;
            VMDevice vmDevice = (VMDevice)device;
            ManagedVMContext context = this.deviceContexts.put(vmDevice, null);
            if (context != null) {
                context.invalidate();
            }
            this.incompleteLoads.add(vmDevice);
        }
    }

    public void removeDevices(Collection<Device> devices) {
        for (Device device : devices) {
            if (!(device instanceof VMDevice)) continue;
            VMDevice vmDevice = (VMDevice)device;
            vmDevice.unmount();
            ManagedVMContext context = this.deviceContexts.remove(vmDevice);
            if (context != null) {
                context.invalidate();
            }
            this.incompleteLoads.remove(vmDevice);
        }
    }

    private void unload() {
        this.deviceContexts.forEach((device, context) -> {
            if (context != null) {
                context.invalidate();
            }
        });
        this.incompleteLoads.clear();
        this.incompleteLoads.addAll(this.deviceContexts.keySet());
    }
}

