/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.global;

import java.util.BitSet;
import li.cil.ceres.api.Serialized;
import li.cil.oc2.api.bus.device.vm.context.InterruptAllocator;
import li.cil.oc2.api.bus.device.vm.context.MemoryAllocator;
import li.cil.oc2.api.bus.device.vm.context.MemoryRangeAllocator;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.context.VMLifecycleEventBus;
import li.cil.oc2.common.vm.context.EventManager;
import li.cil.oc2.common.vm.context.InterruptManager;
import li.cil.oc2.common.vm.context.MemoryRangeManager;
import li.cil.oc2.common.vm.context.VMContextManagerCollection;
import li.cil.oc2.common.vm.context.global.GlobalEventBus;
import li.cil.oc2.common.vm.context.global.GlobalInterruptAllocator;
import li.cil.oc2.common.vm.context.global.GlobalInterruptController;
import li.cil.oc2.common.vm.context.global.GlobalMemoryAllocator;
import li.cil.oc2.common.vm.context.global.GlobalMemoryMap;
import li.cil.oc2.common.vm.context.global.GlobalMemoryRangeAllocator;
import li.cil.oc2.common.vm.context.global.MemoryRangeList;
import li.cil.sedna.api.Board;
import li.cil.sedna.api.device.InterruptController;
import li.cil.sedna.api.memory.MemoryMap;

public final class GlobalVMContext
implements VMContext,
VMContextManagerCollection {
    private final GlobalMemoryMap memoryMap;
    private final GlobalMemoryRangeAllocator memoryRangeAllocator;
    private final GlobalInterruptAllocator interruptAllocator;
    private final GlobalInterruptController interruptController;
    private final GlobalMemoryAllocator memoryAllocator;
    private final GlobalEventBus eventBus;
    private final Runnable joinWorkerThread;
    @Serialized
    private BitSet reservedInterrupts = new BitSet();
    @Serialized
    private MemoryRangeList reservedMemoryRanges = new MemoryRangeList();

    public GlobalVMContext(Board board, Runnable joinWorkerThread) {
        this.memoryMap = new GlobalMemoryMap(board.getMemoryMap());
        this.memoryRangeAllocator = new GlobalMemoryRangeAllocator(board, this.reservedMemoryRanges);
        this.interruptAllocator = new GlobalInterruptAllocator(board.getInterruptCount(), this.reservedInterrupts);
        this.interruptController = new GlobalInterruptController(board.getInterruptController(), this.interruptAllocator);
        this.memoryAllocator = new GlobalMemoryAllocator();
        this.eventBus = new GlobalEventBus();
        this.joinWorkerThread = joinWorkerThread;
    }

    public void updateReservations() {
        this.reservedInterrupts.clear();
        this.reservedInterrupts.or(this.interruptAllocator.getClaimedInterrupts());
        this.reservedMemoryRanges.clear();
        this.reservedMemoryRanges.addAll(this.memoryRangeAllocator.getClaimedMemoryRanges());
    }

    public void postEvent(Object event) {
        this.eventBus.post(event);
    }

    public void invalidate() {
        this.memoryRangeAllocator.invalidate();
        this.interruptController.invalidate();
        this.memoryAllocator.invalidate();
    }

    @Override
    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public InterruptController getInterruptController() {
        return this.interruptController;
    }

    @Override
    public MemoryRangeAllocator getMemoryRangeAllocator() {
        return this.memoryRangeAllocator;
    }

    @Override
    public InterruptAllocator getInterruptAllocator() {
        return this.interruptAllocator;
    }

    @Override
    public MemoryAllocator getMemoryAllocator() {
        return this.memoryAllocator;
    }

    @Override
    public VMLifecycleEventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public void joinWorkerThread() {
        this.joinWorkerThread.run();
    }

    @Override
    public InterruptManager getInterruptManager() {
        return this.interruptAllocator;
    }

    @Override
    public MemoryRangeManager getMemoryRangeManager() {
        return this.memoryRangeAllocator;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventBus;
    }
}

