/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.managed;

import li.cil.oc2.common.vm.context.InterruptValidator;
import li.cil.sedna.api.device.InterruptController;

public final class ManagedInterruptController
implements InterruptController {
    private final InterruptController parent;
    private final InterruptValidator validator;
    private int raisedInterruptMask;
    private boolean isValid = true;

    public ManagedInterruptController(InterruptController parent, InterruptValidator validator) {
        this.parent = parent;
        this.validator = validator;
        this.raisedInterruptMask = validator.getMaskedInterrupts(parent.getRaisedInterrupts());
    }

    public void invalidate() {
        this.isValid = false;
        this.parent.lowerInterrupts(this.raisedInterruptMask);
        this.raisedInterruptMask = 0;
    }

    public Object getIdentity() {
        return this.parent.getIdentity();
    }

    public void raiseInterrupts(int mask) {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        if (this.validator.isMaskValid(mask)) {
            this.parent.raiseInterrupts(mask);
            this.raisedInterruptMask |= mask;
        } else {
            throw new IllegalArgumentException("Trying to raise interrupt not allocated by this context.");
        }
    }

    public void lowerInterrupts(int mask) {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        if (this.validator.isMaskValid(mask)) {
            this.parent.lowerInterrupts(mask);
            this.raisedInterruptMask &= ~mask;
        } else {
            throw new IllegalArgumentException("Trying to lower interrupt not allocated by this context.");
        }
    }

    public int getRaisedInterrupts() {
        return this.raisedInterruptMask;
    }
}

