/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.managed;

import java.util.ArrayList;
import java.util.UUID;
import li.cil.oc2.api.bus.device.vm.context.MemoryAllocator;
import li.cil.oc2.common.vm.Allocator;

final class ManagedMemoryAllocator
implements MemoryAllocator {
    private final ArrayList<UUID> claimedMemory = new ArrayList();
    private boolean isFrozen;

    ManagedMemoryAllocator() {
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void invalidate() {
        for (UUID handle : this.claimedMemory) {
            Allocator.freeMemory(handle);
        }
        this.claimedMemory.clear();
    }

    @Override
    public boolean claimMemory(int size) {
        if (this.isFrozen) {
            throw new IllegalStateException();
        }
        UUID handle = Allocator.createHandle();
        if (!Allocator.claimMemory(handle, size)) {
            return false;
        }
        this.claimedMemory.add(handle);
        return true;
    }
}

