/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.managed;

import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.vm.context.MemoryRangeAllocator;
import li.cil.oc2.common.vm.context.MemoryRangeManager;
import li.cil.sedna.api.device.MemoryMappedDevice;

final class ManagedMemoryRangeAllocator
implements MemoryRangeAllocator {
    private final MemoryRangeAllocator parent;
    private final MemoryRangeManager memoryRangeManager;
    private final Supplier<OptionalLong> baseAddressSupplier;
    private final ArrayList<MemoryMappedDevice> managedDevices = new ArrayList();
    private boolean isFrozen;

    public ManagedMemoryRangeAllocator(MemoryRangeAllocator parent, MemoryRangeManager memoryRangeManager, Supplier<OptionalLong> baseAddressSupplier) {
        this.parent = parent;
        this.memoryRangeManager = memoryRangeManager;
        this.baseAddressSupplier = baseAddressSupplier;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void invalidate() {
        for (MemoryMappedDevice device : this.managedDevices) {
            this.memoryRangeManager.releaseMemoryRange(device);
        }
        this.managedDevices.clear();
    }

    @Override
    public boolean claimMemoryRange(long address, MemoryMappedDevice device) {
        if (this.isFrozen) {
            throw new IllegalStateException();
        }
        if (this.parent.claimMemoryRange(address, device)) {
            this.managedDevices.add(device);
            return true;
        }
        return false;
    }

    @Override
    public OptionalLong claimMemoryRange(MemoryMappedDevice device) {
        if (this.isFrozen) {
            throw new IllegalStateException();
        }
        OptionalLong baseAddress = this.baseAddressSupplier.get();
        if (baseAddress.isPresent()) {
            OptionalLong address = this.memoryRangeManager.findMemoryRange(device, baseAddress.getAsLong());
            if (address.isPresent() && this.parent.claimMemoryRange(address.getAsLong(), device)) {
                this.managedDevices.add(device);
                return address;
            }
        } else {
            OptionalLong address = this.parent.claimMemoryRange(device);
            if (address.isPresent()) {
                this.managedDevices.add(device);
                return address;
            }
        }
        return OptionalLong.empty();
    }
}

